/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networking.util;

import org.apache.commons.lang3.StringUtils;

public final class XmlUtil {
    private static final CodePointMarker[] XML_1_0_ALLOWED_CODEPOINTS = new CodePointMarker[]{new CodePointMarker(9), new CodePointMarker(10), new CodePointMarker(13), new CodePointMarker(32, 55295), new CodePointMarker(57344, 65533), new CodePointMarker(65536, 0x10FFFF)};

    public static int validateAllowedCharacters(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return -1;
        }
        char[] charContent = content.toCharArray();
        for (int index = 0; index < charContent.length; ++index) {
            char current = charContent[index];
            if (XmlUtil.isCharacterIn(current, XML_1_0_ALLOWED_CODEPOINTS)) continue;
            if (index + 1 <= charContent.length && Character.isHighSurrogate(current) && Character.isLowSurrogate(charContent[index + 1])) {
                int codePoint = Character.toCodePoint(current, charContent[index + 1]);
                if (XmlUtil.isCharacterIn(codePoint, XML_1_0_ALLOWED_CODEPOINTS)) {
                    ++index;
                    continue;
                }
                return index;
            }
            return index;
        }
        return -1;
    }

    private static boolean isCharacterIn(int ch, CodePointMarker[] marketSet) {
        if (marketSet != null) {
            for (CodePointMarker marker : marketSet) {
                if (!marker.matches(ch)) continue;
                return true;
            }
        }
        return false;
    }

    private XmlUtil() {
    }

    private static final class CodePointMarker {
        public final int start;
        public final int end;

        CodePointMarker(int startChar, int endChar) {
            this.start = startChar;
            this.end = endChar;
        }

        CodePointMarker(int singlePoint) {
            this(singlePoint, singlePoint);
        }

        public final boolean matches(int character) {
            return character >= this.start && character <= this.end;
        }
    }
}

