/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.vm.QuestionInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class VmQueryFilterBuilder
implements QueryFilterBuilder {
    private final String VM_QUESTION_PROP_NAME = "runtime/question";
    private final String VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME = "vmQuestionId";
    private final QueryServiceFactory _queryServiceFactory;
    private final ObjectReferenceService _objectReferenceService;

    public VmQueryFilterBuilder(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._queryServiceFactory = queryServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="otherVmsWithSameQuesitonFilter")
    public Filter otherVmsWithSameQuesitonFilter(String vmId) {
        Validate.notNull((Object)vmId);
        QueryService queryService = this._queryServiceFactory.getQueryService();
        Object reference = this._objectReferenceService.getReference(vmId, true);
        if (!(reference instanceof ManagedObjectReference)) {
            return null;
        }
        ManagedObjectReference vmRef = (ManagedObjectReference)reference;
        ResultSet vmQuestionResult = queryService.select(new String[]{"runtime/question"}).from(new String[]{vmRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef)}).fetch();
        QuestionInfo vmQuestion = (QuestionInfo)((ResourceItem)vmQuestionResult.getItems().get(0)).getPropertyValues().get(0);
        if (vmQuestion == null) {
            return null;
        }
        String firstMessageId = vmQuestion.getMessage()[0].getId();
        PropertyPredicate sameVcVmsPredicates = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef.getServerGuid());
        PropertyPredicate excludeSourceVmPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)vmRef);
        PropertyPredicate sameQuestionVmsPredicate = new PropertyPredicate("vmQuestionId", PropertyPredicate.ComparisonOperator.EQUAL, (Object)firstMessageId);
        ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>(3);
        predicates.add(sameVcVmsPredicates);
        predicates.add(excludeSourceVmPredicate);
        predicates.add(sameQuestionVmsPredicate);
        return new Filter(predicates);
    }

    @QueryFilter(value="hostsInDatacenterByMorObjectsFilter")
    public Filter hostsInDatacenterByMorObjectsFilter(String datacenterId, String[] hosts) {
        Validate.notNull((Object)datacenterId);
        Validate.notNull((Object)hosts);
        Validate.isTrue((hosts.length == 0 || StringUtils.isNoneBlank((CharSequence[])hosts) ? 1 : 0) != 0);
        ManagedObjectReference reference = (ManagedObjectReference)this._objectReferenceService.getReference(datacenterId, true);
        if (!(reference instanceof ManagedObjectReference)) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        List<Object> hostObjectsToBeIncluded = this.getObjectRefsById(hosts);
        this.addObjectsByMorPredicate(predicateList, hostObjectsToBeIncluded);
        return new Filter(predicateList);
    }

    private List<Object> getObjectRefsById(String[] objectIds) {
        ArrayList<Object> objects = new ArrayList<Object>(objectIds.length);
        for (String objectId : objectIds) {
            objects.add(this._objectReferenceService.getReference(objectId, true));
        }
        return objects;
    }

    private void addObjectsByMorPredicate(List<PropertyPredicate> predicateList, Collection<Object> objects) {
        PropertyPredicate alreadySelectedObjects = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects);
        predicateList.add(alreadySelectedObjects);
    }
}

