/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.vm.model.VmAdvancedStoragePageData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VmAdvancedStoragePagePropertyProvider
implements PropertyProviderBean {
    private QueryService _queryService;
    private static final String VIRTUAL_DISKS_PROPERTY = "virtualDisks";
    private static final String VM_HOME_DATASTORE_PROPERTY = "vmHomeDatastore";
    private static final String VM_REPLICATION_GROUP_ASSIGNMENTS_PROPERTY = "vmReplicationGroupAssignments";
    private static final String STORAGE_POLICIES_ASSIGNMENTS_PROPERTY = "vmStorageProfileAssignments";
    private static final String HOST_PROPERTY = "host";

    public VmAdvancedStoragePagePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="VirtualMachine")
    public VmAdvancedStoragePageData getMigrateAdvancedStoragePageData(ManagedObjectReference vmRef) {
        return this.getAdvancedStoragePageData(vmRef, true);
    }

    @type(value="VirtualMachine")
    public VmAdvancedStoragePageData getAdvancedStoragePageData(ManagedObjectReference vmRef) {
        return this.getAdvancedStoragePageData(vmRef, false);
    }

    private VmAdvancedStoragePageData getAdvancedStoragePageData(ManagedObjectReference vmRef, boolean isMigrate) {
        String[] propertiesToRetrieve = new String[]{VIRTUAL_DISKS_PROPERTY, VM_HOME_DATASTORE_PROPERTY, VM_REPLICATION_GROUP_ASSIGNMENTS_PROPERTY, STORAGE_POLICIES_ASSIGNMENTS_PROPERTY};
        if (isMigrate) {
            propertiesToRetrieve = new String[]{VIRTUAL_DISKS_PROPERTY, VM_HOME_DATASTORE_PROPERTY, VM_REPLICATION_GROUP_ASSIGNMENTS_PROPERTY, STORAGE_POLICIES_ASSIGNMENTS_PROPERTY, HOST_PROPERTY};
        }
        VmAdvancedStoragePageData result = new VmAdvancedStoragePageData();
        ArrayList<ManagedObjectReference> vmRefs = new ArrayList<ManagedObjectReference>();
        vmRefs.add(vmRef);
        Map res = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vmRefs, (String[])propertiesToRetrieve);
        Map properties = (Map)res.get(vmRef);
        if (properties == null) {
            return result;
        }
        this.retrieveProperties(properties, result, isMigrate);
        return result;
    }

    private void retrieveProperties(Map propertyResult, VmAdvancedStoragePageData result, boolean isMigrate) {
        if (propertyResult.get(VIRTUAL_DISKS_PROPERTY) != null) {
            result.virtualDisks = (VirtualDisk[])propertyResult.get(VIRTUAL_DISKS_PROPERTY);
        }
        if (propertyResult.get(VM_HOME_DATASTORE_PROPERTY) != null) {
            result.vmHomeDatastore = (ManagedObjectReference)propertyResult.get(VM_HOME_DATASTORE_PROPERTY);
        }
        if (propertyResult.get(VM_REPLICATION_GROUP_ASSIGNMENTS_PROPERTY) != null) {
            result.vmReplicationGroupAssignments = (List)propertyResult.get(VM_REPLICATION_GROUP_ASSIGNMENTS_PROPERTY);
        }
        if (propertyResult.get(STORAGE_POLICIES_ASSIGNMENTS_PROPERTY) != null) {
            result.storagePoliciesAssignments = (VmStorageProfileAssignmentsData)propertyResult.get(STORAGE_POLICIES_ASSIGNMENTS_PROPERTY);
        }
        if (isMigrate && propertyResult.get(HOST_PROPERTY) != null) {
            result.host = (ManagedObjectReference)propertyResult.get(HOST_PROPERTY);
        }
    }
}

