/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.AggregatedClusterData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.service.AggregatedClusterDataService;
import com.vmware.vsphere.client.h5.vm.service.VmStorageLocatorService;
import com.vmware.vsphere.client.h5.vm.service.provisioning.VmProvisioningStorageLocatorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmStorageLocatorDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmStorageLocatorDerivedPropertyProviderAdapter.class);
    private static final String PROPERTY_DATASTORE = "datastore";
    private static final String PROPERTY_CLUSTER = "cluster";
    private static final String PROPERTY_OWNER = "owner";
    private static final String PROPERTY_LOCATOR_ITEMS = "storageLocator:provisioningStorageLocatorItemsData";
    private static final String PROPERTY_REMOTE_VSAN_DATASTORES = "storageLocator:remoteVsanDatastores";
    private static Map<String, DerivedPropertyInfo[]> TYPE_MAP = new HashMap<String, DerivedPropertyInfo[]>();
    private final DataServiceExtensionRegistry _dataServiceExtensionRegistry;
    private final VmProvisioningStorageLocatorService _vmProvisioningStorageLocatorService;
    private final VmStorageLocatorService _vmStorageLocatorService;
    private final AggregatedClusterDataService _aggregatedClusterDataService;
    private final ThreadPoolExecutor _threadPoolExecutor;

    public VmStorageLocatorDerivedPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, VmProvisioningStorageLocatorService vmProvisioningStorageLocatorService, VmStorageLocatorService vmStorageLocatorService, AggregatedClusterDataService aggregatedClusterDataService, ThreadPoolExecutor threadPoolExecutor) {
        this._dataServiceExtensionRegistry = dataServiceExtensionRegistry;
        this._vmProvisioningStorageLocatorService = vmProvisioningStorageLocatorService;
        this._vmStorageLocatorService = vmStorageLocatorService;
        this._aggregatedClusterDataService = aggregatedClusterDataService;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    public void initialize() {
        this._dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, VmStorageLocatorDerivedPropertyProviderAdapter.getTypeInfo());
    }

    public void destroy() {
        this._dataServiceExtensionRegistry.unregisterDataAdapter((PropertyProviderAdapter)this);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        if (!VmStorageLocatorDerivedPropertyProviderAdapter.checkPropertyRequestSpec(propertyRequest)) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet rs = new ResultSet();
        ArrayList<ResultItem> itemList = new ArrayList<ResultItem>();
        for (Object obj : propertyRequest.objects) {
            ResultItem item = VmStorageLocatorDerivedPropertyProviderAdapter.newResultItem(obj);
            itemList.add(item);
            for (PropertySpec pSpec : propertyRequest.properties) {
                if (this.shouldComputeProperty(PROPERTY_LOCATOR_ITEMS, obj, pSpec)) {
                    StorageLocatorItemsData propertyValue = this.computeProvisioningStorageLocatorItemsData((ManagedObjectReference)obj, propertyRequest.derivedPropertyData);
                    ResultUtil.addProperty((ResultItem)item, (PropertyValue)ResultUtil.newProperty((String)PROPERTY_LOCATOR_ITEMS, (Object)propertyValue));
                    continue;
                }
                if (!this.shouldComputeProperty(PROPERTY_REMOTE_VSAN_DATASTORES, obj, pSpec)) continue;
                Collection<ManagedObjectReference> remoteVsanDatastores = this.computeRemoteVsanDatastore((ManagedObjectReference)obj, pSpec, propertyRequest.derivedPropertyData);
                ResultUtil.addProperty((ResultItem)item, (PropertyValue)ResultUtil.newProperty((String)PROPERTY_REMOTE_VSAN_DATASTORES, remoteVsanDatastores));
            }
        }
        rs.items = itemList.toArray(new ResultItem[itemList.size()]);
        rs.totalMatchedObjectCount = itemList.size();
        return rs;
    }

    private StorageLocatorItemsData computeProvisioningStorageLocatorItemsData(ManagedObjectReference objRef, DerivedPropertyData derivedData) {
        StorageLocatorItemsData storageLocatorItemsData;
        if (objRef == null || derivedData == null) {
            return null;
        }
        Map derivedProperties = derivedData.getSourcePropertyValuesByObject();
        Future<AggregatedClusterData> clusterDataQuery = this.submitClusterDataQuery(objRef, derivedProperties);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualApp.class)) {
            ManagedObjectReference computeResource = (ManagedObjectReference)VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(objRef, PROPERTY_OWNER, derivedProperties);
            storageLocatorItemsData = this._vmProvisioningStorageLocatorService.getStorageLocatorData(computeResource, null);
        } else {
            Object[] datastores = (Object[])VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(objRef, PROPERTY_DATASTORE, derivedProperties);
            storageLocatorItemsData = this._vmProvisioningStorageLocatorService.getStorageLocatorData(objRef, datastores);
        }
        try {
            storageLocatorItemsData.aggregatedClusterData = clusterDataQuery.get();
        }
        catch (Exception e) {
            _logger.warn((Object)"Cannot compute aggregated cluster data.", (Throwable)e);
            storageLocatorItemsData.aggregatedClusterData = new AggregatedClusterData();
        }
        return storageLocatorItemsData;
    }

    private Collection<ManagedObjectReference> computeRemoteVsanDatastore(ManagedObjectReference objRef, PropertySpec propertySpec, DerivedPropertyData derivedData) {
        ManagedObjectReference clusterComputeResource;
        Collection vsanDatastoresRefs = (Collection)VmStorageLocatorDerivedPropertyProviderAdapter.getPropertyParameterData(PROPERTY_REMOTE_VSAN_DATASTORES, propertySpec);
        if (objRef == null || vsanDatastoresRefs == null) {
            return null;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ClusterComputeResource.class)) {
            clusterComputeResource = objRef;
        } else {
            Map derivedProperties = derivedData.getSourcePropertyValuesByObject();
            clusterComputeResource = (ManagedObjectReference)VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(objRef, PROPERTY_CLUSTER, derivedProperties);
        }
        return this._vmStorageLocatorService.calculateRemoteVsanDatastores(clusterComputeResource, vsanDatastoresRefs);
    }

    private boolean shouldComputeProperty(String propertyName, Object obj, PropertySpec propSpec) {
        if (!(obj instanceof ManagedObjectReference)) {
            return false;
        }
        ManagedObjectReference ref = (ManagedObjectReference)obj;
        if (!TYPE_MAP.containsKey(ref.getType())) {
            return false;
        }
        return ArrayUtils.contains((Object[])propSpec.propertyNames, (Object)propertyName);
    }

    private Future<AggregatedClusterData> submitClusterDataQuery(ManagedObjectReference contextObj, Map<Object, Map<String, Object>> derivedProperties) {
        try {
            final ManagedObjectReference[] clusterRefs = ManagedObjectUtil.isOfType((ManagedObjectReference)contextObj, ClusterComputeResource.class) ? new ManagedObjectReference[]{contextObj} : (this.containsDerivedProperty(contextObj, PROPERTY_CLUSTER, derivedProperties) && ManagedObjectUtil.isOfType((ManagedObjectReference)contextObj, HostSystem.class) ? new ManagedObjectReference[]{(ManagedObjectReference)VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(contextObj, PROPERTY_CLUSTER, derivedProperties)} : (this.containsDerivedProperty(contextObj, PROPERTY_CLUSTER, derivedProperties) ? (ManagedObjectReference[])VmStorageLocatorDerivedPropertyProviderAdapter.getDerivedPropertyValue(contextObj, PROPERTY_CLUSTER, derivedProperties) : new ManagedObjectReference[]{}));
            final HttpServletRequest httpRequest = SessionUtil.getHttpRequest();
            return this._threadPoolExecutor.submit(new Callable<AggregatedClusterData>(){

                @Override
                public AggregatedClusterData call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)httpRequest);
                    return VmStorageLocatorDerivedPropertyProviderAdapter.this._aggregatedClusterDataService.queryAggregatedClusterData(clusterRefs);
                }
            });
        }
        catch (Exception e) {
            _logger.warn((Object)"Cannot compute aggregated cluster data.", (Throwable)e);
            return CompletableFuture.completedFuture(new AggregatedClusterData());
        }
    }

    private static <T> T getDerivedPropertyValue(Object obj, String propertyName, Map<Object, Map<String, Object>> derivedProperties) {
        Map<String, Object> objectProperties = derivedProperties.get(obj);
        if (objectProperties == null || !objectProperties.containsKey(propertyName)) {
            throw new RuntimeException(String.format("Derived data for %s does not contain property %s", obj.toString(), propertyName));
        }
        Object result = objectProperties.get(propertyName);
        return (T)result;
    }

    private static <T> T getPropertyParameterData(String propertyName, PropertySpec propSpec) {
        ParameterSpec[] parameterSpecs;
        for (ParameterSpec parameterSpec : parameterSpecs = propSpec.parameters) {
            if (!propertyName.equals(parameterSpec.propertyName)) continue;
            return (T)parameterSpec.parameter;
        }
        return null;
    }

    private boolean containsDerivedProperty(Object obj, String propertyName, Map<Object, Map<String, Object>> derivedProperties) {
        Map<String, Object> objectProperties = derivedProperties.get(obj);
        return objectProperties != null && objectProperties.containsKey(propertyName);
    }

    private static boolean checkPropertyRequestSpec(PropertyRequestSpec spec) {
        if (ArrayUtils.isEmpty((Object[])spec.objects) || ArrayUtils.isEmpty((Object[])spec.properties)) {
            _logger.error((Object)"Invalid property request spec send by data service.");
            return false;
        }
        return true;
    }

    private static TypeInfo[] getTypeInfo() {
        TypeInfo[] typeInfo = new TypeInfo[TYPE_MAP.size()];
        int index = 0;
        for (Map.Entry<String, DerivedPropertyInfo[]> entry : TYPE_MAP.entrySet()) {
            typeInfo[index++] = VmStorageLocatorDerivedPropertyProviderAdapter.newTypeInfo(entry.getKey(), entry.getValue());
        }
        return typeInfo;
    }

    private static ResultItem newResultItem(Object obj) {
        ResultItem item = new ResultItem();
        item.resourceObject = obj;
        item.properties = new PropertyValue[0];
        return item;
    }

    private static TypeInfo newTypeInfo(String objectType, DerivedPropertyInfo[] derivedProperties) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = objectType;
        typeInfo.derivedProperties = derivedProperties;
        typeInfo.properties = new String[derivedProperties.length];
        for (int index = 0; index < derivedProperties.length; ++index) {
            typeInfo.properties[index] = derivedProperties[index].propertyName;
        }
        return typeInfo;
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String computedProperty, String[] sourceProperties) {
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = computedProperty;
        derivedInfo.sourcePropertyNames = sourceProperties;
        return derivedInfo;
    }

    static {
        TYPE_MAP.put(HostSystem.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE, PROPERTY_CLUSTER}), VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_REMOTE_VSAN_DATASTORES, new String[]{PROPERTY_CLUSTER})});
        TYPE_MAP.put(ComputeResource.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE, PROPERTY_CLUSTER}), VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_REMOTE_VSAN_DATASTORES, new String[]{PROPERTY_CLUSTER})});
        TYPE_MAP.put(ClusterComputeResource.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_DATASTORE}), VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_REMOTE_VSAN_DATASTORES, new String[0])});
        TYPE_MAP.put(ResourcePool.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_OWNER, PROPERTY_CLUSTER}), VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_REMOTE_VSAN_DATASTORES, new String[]{PROPERTY_CLUSTER})});
        TYPE_MAP.put(VirtualApp.class.getSimpleName(), new DerivedPropertyInfo[]{VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_LOCATOR_ITEMS, new String[]{PROPERTY_OWNER, PROPERTY_CLUSTER}), VmStorageLocatorDerivedPropertyProviderAdapter.newDerivedPropertyInfo(PROPERTY_REMOTE_VSAN_DATASTORES, new String[]{PROPERTY_CLUSTER})});
    }
}

