/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.vm.EnvironmentBrowserUnavailableException;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationStorageLocatorSpec;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.AggregatedClusterData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.DatastoreQueryBinding;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorDatastoreItem;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorStoragePodItem;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StoragePodQueryBinding;
import com.vmware.vsphere.client.h5.vm.service.AggregatedClusterDataService;
import com.vmware.vsphere.client.h5.vm.service.migration.VmMigrationStorageLocatorService;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import com.vmware.vsphere.client.util.envbrowser.EnvironmentBrowserUtil;
import com.vmware.vsphere.client.vm.api.model.provisioning.VirtualDiskFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmStorageLocatorPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmStorageLocatorPropertyProvider.class);
    private static final String OWNER_PROPERTY = "owner";
    private static final String PARENT_PROPERTY = "parent";
    private static final String VMFS_TYPE = "VMFS";
    private static final String VVOL_TYPE = "VVOL";
    private static final String NFS41_TYPE = "NFS41";
    private static final String NFS3_TYPE = "NFS";
    private static final String VSAN_TYPE = "vsan";
    private final QueryBindingService _queryBindingService;
    private final QueryExecutor _queryExecutor;
    private final VmMigrationStorageLocatorService _migrationStorageLocatorService;
    private final AggregatedClusterDataService _aggregatedClusterDataService;
    private final ThreadPoolExecutor _threadPoolExecutor;

    public VmStorageLocatorPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryExecutor queryExecutor, VmMigrationStorageLocatorService migrationStorageLocatorService, AggregatedClusterDataService aggregatedClusterDataService, ThreadPoolExecutor threadPoolExecutor) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryExecutor = queryExecutor;
        this._migrationStorageLocatorService = migrationStorageLocatorService;
        this._aggregatedClusterDataService = aggregatedClusterDataService;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @ModelMetadata(type={"VirtualMachine"}, propertyNamespace="storageLocator", property="migrationStorageLocatorItemsData")
    public StorageLocatorItemsData getMigrationStorageLocatorItemsData(ManagedObjectReference vmRef, VmMigrationStorageLocatorSpec spec) {
        ManagedObjectReference[] managedObjectReferenceArray;
        if (spec.resource != null) {
            ManagedObjectReference[] managedObjectReferenceArray2 = new ManagedObjectReference[1];
            managedObjectReferenceArray = managedObjectReferenceArray2;
            managedObjectReferenceArray2[0] = spec.resource;
        } else {
            managedObjectReferenceArray = spec.vms;
        }
        ManagedObjectReference[] contextObjects = managedObjectReferenceArray;
        Future<AggregatedClusterData> clusterDataQuery = this.submitClusterDataQuery(contextObjects);
        StorageLocatorItemsData storageLocatorItemsData = this._migrationStorageLocatorService.getStorageLocatorData(spec);
        try {
            storageLocatorItemsData.aggregatedClusterData = clusterDataQuery.get();
            if (storageLocatorItemsData.aggregatedClusterData.commonParentCluster != null) {
                storageLocatorItemsData.computeResource = storageLocatorItemsData.aggregatedClusterData.commonParentCluster;
            }
        }
        catch (Exception e) {
            storageLocatorItemsData.aggregatedClusterData = new AggregatedClusterData();
        }
        return storageLocatorItemsData;
    }

    @ModelMetadata(type={"HostSystem", "ClusterComputeResource", "VirtualApp", "ResourcePool", "VirtualMachine"}, propertyNamespace="storageLocator", property="storageLocatorItemsData")
    public StorageLocatorItemsData getStorageLocatorItemsData(ManagedObjectReference moRef, ManagedObjectReference hostRef) throws EnvironmentBrowserUnavailableException {
        EnvironmentBrowser environmentBrowser;
        StorageLocatorItemsData result = new StorageLocatorItemsData();
        Future<AggregatedClusterData> clusterDataQuery = this.submitClusterDataQuery(new ManagedObjectReference[]{moRef});
        try {
            environmentBrowser = this.getEnvironmentBrowser(moRef);
        }
        catch (Exception e) {
            throw new EnvironmentBrowserUnavailableException(String.format("Could not fetch the environment browser of '%s'", moRef.toString()), e);
        }
        Map<ManagedObjectReference, DatastoreInfo> datastoreInfos = this.getDatastoreInfoForEnvironmentBrowser(environmentBrowser, hostRef);
        if (datastoreInfos.isEmpty()) {
            result.storagePodItems = new StorageLocatorStoragePodItem[0];
            result.datastoreItems = new StorageLocatorDatastoreItem[0];
            return result;
        }
        Collection dsProperties = this._queryBindingService.prepare(DatastoreQueryBinding.class).fetch(datastoreInfos.keySet());
        ArrayList<StorageLocatorDatastoreItem> datastoreItems = new ArrayList<StorageLocatorDatastoreItem>();
        ArrayList<StorageLocatorStoragePodItem> storagePodItems = new ArrayList<StorageLocatorStoragePodItem>();
        HashMap<ManagedObjectReference, List<ManagedObjectReference>> datastoresByPod = new HashMap<ManagedObjectReference, List<ManagedObjectReference>>();
        this.getDatastoresByPod(datastoreInfos, dsProperties, datastoreItems, storagePodItems, datastoresByPod);
        VmStorageLocatorPropertyProvider.populateAggregatedProperties(datastoreItems, storagePodItems, datastoreInfos, datastoresByPod);
        result.computeResource = hostRef;
        result.datastoreItems = datastoreItems.toArray(new StorageLocatorDatastoreItem[datastoreItems.size()]);
        result.storagePodItems = storagePodItems.toArray(new StorageLocatorStoragePodItem[storagePodItems.size()]);
        try {
            result.aggregatedClusterData = clusterDataQuery.get();
        }
        catch (Exception e) {
            _logger.warn((Object)"Cannot compute aggregated cluster data.", (Throwable)e);
            result.aggregatedClusterData = new AggregatedClusterData();
        }
        Arrays.sort(result.datastoreItems, new Comparator<StorageLocatorDatastoreItem>(){

            @Override
            public int compare(StorageLocatorDatastoreItem o1, StorageLocatorDatastoreItem o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        Arrays.sort(result.storagePodItems, new Comparator<StorageLocatorStoragePodItem>(){

            @Override
            public int compare(StorageLocatorStoragePodItem o1, StorageLocatorStoragePodItem o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return result;
    }

    private void getDatastoresByPod(Map<ManagedObjectReference, DatastoreInfo> datastoreInfos, Collection<DatastoreQueryBinding> dsProperties, List<StorageLocatorDatastoreItem> datastoreItems, List<StorageLocatorStoragePodItem> storagePodItems, HashMap<ManagedObjectReference, List<ManagedObjectReference>> datastoresByPod) {
        for (DatastoreQueryBinding datastoreQueryBinding : dsProperties) {
            ManagedObjectReference dsRef = (ManagedObjectReference)datastoreQueryBinding.provider;
            DatastoreInfo dsInfo = datastoreInfos.get(dsRef);
            if (dsInfo == null) continue;
            StorageLocatorDatastoreItem datastoreItem = this.newDatastoreItem(dsInfo, datastoreQueryBinding);
            datastoreItems.add(datastoreItem);
            if (datastoreItem.parentStoragePod == null) continue;
            if (!datastoresByPod.containsKey(datastoreItem.parentStoragePod)) {
                StorageLocatorStoragePodItem podItem = this.newStoragePodItem(datastoreQueryBinding.parentPod);
                storagePodItems.add(podItem);
                datastoresByPod.put(datastoreItem.parentStoragePod, new ArrayList());
            }
            datastoresByPod.get(datastoreItem.parentStoragePod).add(datastoreItem.storageRef);
        }
    }

    private StorageLocatorDatastoreItem newDatastoreItem(DatastoreInfo dsInfo, DatastoreQueryBinding datastoreQueryBinding) {
        StorageLocatorDatastoreItem datastoreItem = new StorageLocatorDatastoreItem();
        datastoreItem.name = dsInfo.datastore.name;
        datastoreItem.storageRef = dsInfo.datastore.datastore;
        datastoreItem.capacity = dsInfo.datastore.capacity;
        datastoreItem.freeSpace = dsInfo.datastore.freeSpace;
        datastoreItem.provisionedSpace = dsInfo.datastore.capacity - dsInfo.datastore.freeSpace;
        if (dsInfo.datastore.uncommitted != null) {
            datastoreItem.provisionedSpace += dsInfo.datastore.uncommitted.longValue();
        }
        if (datastoreQueryBinding.parentPod != null) {
            datastoreItem.parentStoragePod = (ManagedObjectReference)datastoreQueryBinding.parentPod.provider;
        }
        datastoreItem.type = dsInfo.datastore.type;
        datastoreItem.formattedType = this.formatDatastoreType(dsInfo.datastore.type, datastoreQueryBinding.vmfsMajorVersion);
        if (FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(dsInfo.vStorageSupport)) {
            datastoreItem.vStorageSupported = true;
        }
        if (datastoreQueryBinding.grantedPrivileges != null) {
            datastoreItem.hasAllocateSpacePrivilege = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{"Datastore.AllocateSpace"}, (String[])datastoreQueryBinding.grantedPrivileges);
        }
        datastoreItem.isLogicalDatastore = datastoreQueryBinding.aliasOf != null && datastoreQueryBinding.containerId != null && !datastoreQueryBinding.aliasOf.equals(datastoreQueryBinding.containerId);
        return datastoreItem;
    }

    private String formatDatastoreType(String dsType, Integer vmfsMajorVersion) {
        if (VMFS_TYPE.equalsIgnoreCase(dsType)) {
            if (vmfsMajorVersion != null) {
                return VmStringUtil.getString("dsType.vmfsWithVersion", vmfsMajorVersion.toString());
            }
            return VmStringUtil.getString("dsType.vmfs");
        }
        if (NFS3_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.nfs3");
        }
        if (NFS41_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.nfs41");
        }
        if (VSAN_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.vsan");
        }
        if (VVOL_TYPE.equalsIgnoreCase(dsType)) {
            return VmStringUtil.getString("dsType.vvol");
        }
        return dsType;
    }

    private StorageLocatorStoragePodItem newStoragePodItem(StoragePodQueryBinding storagePodInfo) {
        StorageLocatorStoragePodItem podItem = new StorageLocatorStoragePodItem();
        podItem.storageRef = (ManagedObjectReference)storagePodInfo.provider;
        podItem.name = storagePodInfo.summary.name;
        podItem.capacity = storagePodInfo.summary.capacity;
        podItem.freeSpace = storagePodInfo.summary.freeSpace;
        podItem.provisionedSpace = storagePodInfo.summary.capacity - storagePodInfo.summary.freeSpace;
        podItem.drsEnabled = Boolean.TRUE.equals(storagePodInfo.drsEnabled);
        return podItem;
    }

    private Map<ManagedObjectReference, DatastoreInfo> getDatastoreInfoForEnvironmentBrowser(EnvironmentBrowser envBrowser, ManagedObjectReference hostRef) {
        HashMap<ManagedObjectReference, DatastoreInfo> result = new HashMap<ManagedObjectReference, DatastoreInfo>();
        if (envBrowser == null) {
            return result;
        }
        EnvironmentBrowser.ConfigTargetQuerySpec configTargetQuerySpec = new EnvironmentBrowser.ConfigTargetQuerySpec();
        configTargetQuerySpec.includeDatastores = true;
        configTargetQuerySpec.includeDevices = false;
        configTargetQuerySpec.includeDisks = false;
        configTargetQuerySpec.includeNetworks = false;
        configTargetQuerySpec.vmSpecific = false;
        ConfigTarget configTarget = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)envBrowser, (ManagedObjectReference)hostRef, (EnvironmentBrowser.ConfigTargetQuerySpec)configTargetQuerySpec);
        if (configTarget == null || configTarget.datastore == null || configTarget.datastore.length == 0) {
            return result;
        }
        for (DatastoreInfo dsInfo : configTarget.datastore) {
            if (!this.isDatastoreAccessible(dsInfo) || !this.isDatastoreApplicable(dsInfo)) continue;
            result.put(dsInfo.datastore.datastore, dsInfo);
        }
        return result;
    }

    private boolean isDatastoreAccessible(DatastoreInfo dsInfo) {
        return MountInfo.AccessMode.readWrite.toString().equals(dsInfo.mode) && dsInfo.datastore.accessible && Datastore.Summary.MaintenanceModeState.normal.toString().equals(dsInfo.datastore.maintenanceMode);
    }

    private boolean isDatastoreApplicable(DatastoreInfo dsInfo) {
        if (dsInfo != null && dsInfo.getDatastore() != null) {
            return !H5StorageUtil.isVsanDirectDatastore((Datastore.Summary)dsInfo.getDatastore());
        }
        return true;
    }

    private EnvironmentBrowser getEnvironmentBrowser(ManagedObjectReference moRef) throws Exception {
        ManagedObjectReference environmentBrowserRef = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VirtualMachine.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForVm(moRef);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VirtualApp.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource((ManagedObjectReference)this._queryExecutor.getProperty((Object)moRef, OWNER_PROPERTY));
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource((ManagedObjectReference)this._queryExecutor.getProperty((Object)moRef, PARENT_PROPERTY));
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ClusterComputeResource.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource(moRef);
        }
        if (environmentBrowserRef == null) {
            return null;
        }
        return (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)environmentBrowserRef);
    }

    private ManagedObjectReference getEnvironmentBrowserForComputeResource(ManagedObjectReference computeResourceMor) throws Exception {
        if (computeResourceMor != null) {
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)computeResourceMor);
            return computeResource.getEnvironmentBrowser();
        }
        return null;
    }

    private ManagedObjectReference getEnvironmentBrowserForVm(ManagedObjectReference vmMor) throws Exception {
        if (vmMor != null) {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmMor);
            return vm.getEnvironmentBrowser();
        }
        return null;
    }

    private static void populateAggregatedProperties(List<StorageLocatorDatastoreItem> datastoreItems, List<StorageLocatorStoragePodItem> storagePodItems, Map<ManagedObjectReference, DatastoreInfo> datastoreInfos, HashMap<ManagedObjectReference, List<ManagedObjectReference>> datastoresByPod) {
        for (StorageLocatorDatastoreItem storageLocatorDatastoreItem : datastoreItems) {
            DatastoreInfo dsInfo = datastoreInfos.get(storageLocatorDatastoreItem.storageRef);
            List<DatastoreInfo> dsList = Arrays.asList(dsInfo);
            storageLocatorDatastoreItem.diskFormatsAvailable = VmStorageLocatorPropertyProvider.getSupportedFormats(dsList);
            storageLocatorDatastoreItem.hardwareAcceleration = VmStorageLocatorPropertyProvider.getHardwareAcceleration(dsList);
            storageLocatorDatastoreItem.multipleHostAccess = VmStorageLocatorPropertyProvider.getMultipleHostAccess(dsList);
            storageLocatorDatastoreItem.thinProvisioningSupported = VmStorageLocatorPropertyProvider.getThinProvisioningSupported(dsList);
        }
        for (StorageLocatorStoragePodItem storageLocatorStoragePodItem : storagePodItems) {
            ArrayList<DatastoreInfo> dsInfos = new ArrayList<DatastoreInfo>();
            for (ManagedObjectReference ds : datastoresByPod.get(storageLocatorStoragePodItem.storageRef)) {
                dsInfos.add(datastoreInfos.get(ds));
            }
            storageLocatorStoragePodItem.diskFormatsAvailable = VmStorageLocatorPropertyProvider.getSupportedFormats(dsInfos);
            storageLocatorStoragePodItem.hardwareAcceleration = VmStorageLocatorPropertyProvider.getHardwareAcceleration(dsInfos);
            storageLocatorStoragePodItem.multipleHostAccess = VmStorageLocatorPropertyProvider.getMultipleHostAccess(dsInfos);
            storageLocatorStoragePodItem.thinProvisioningSupported = VmStorageLocatorPropertyProvider.getThinProvisioningSupported(dsInfos);
            storageLocatorStoragePodItem.isRDMSupported = VmStorageLocatorPropertyProvider.isRDMSupported(dsInfos);
        }
    }

    private static boolean isRDMSupported(List<DatastoreInfo> dsInfos) {
        if (dsInfos.isEmpty()) {
            return false;
        }
        return dsInfos.get((int)0).capability.rawDiskMappingsSupported;
    }

    private static boolean getMultipleHostAccess(List<DatastoreInfo> dsInfos) {
        for (DatastoreInfo dsInfo : dsInfos) {
            if (!Boolean.TRUE.equals(dsInfo.datastore.multipleHostAccess)) continue;
            return true;
        }
        return false;
    }

    private static boolean getThinProvisioningSupported(List<DatastoreInfo> dsInfos) {
        for (DatastoreInfo dsInfo : dsInfos) {
            if (dsInfo.capability.perFileThinProvisioningSupported) continue;
            return false;
        }
        return true;
    }

    private static String getHardwareAcceleration(List<DatastoreInfo> dsInfos) {
        boolean hasUnknown = false;
        boolean hasUnsupported = false;
        for (DatastoreInfo dsInfo : dsInfos) {
            if (FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(dsInfo.vStorageSupport)) continue;
            if (FileSystemMountInfo.VStorageSupportStatus.vStorageUnsupported.toString().equals(dsInfo.vStorageSupport)) {
                hasUnsupported = true;
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown) {
            return VmStringUtil.getString("hwAcceleration.unknown");
        }
        if (hasUnsupported) {
            return VmStringUtil.getString("hwAcceleration.notSupported");
        }
        return VmStringUtil.getString("hwAcceleration.supported");
    }

    private static List<VirtualDiskFormat> getSupportedFormats(List<DatastoreInfo> dsInfos) {
        boolean acceleration;
        String firstDatastoreType;
        ArrayList<VirtualDiskFormat> result = new ArrayList<VirtualDiskFormat>();
        String string = firstDatastoreType = !dsInfos.isEmpty() ? dsInfos.get((int)0).datastore.type : null;
        if (VVOL_TYPE.equals(firstDatastoreType)) {
            result.add(VirtualDiskFormat.thin);
            result.add(VirtualDiskFormat.nativeThick);
            return result;
        }
        if (VSAN_TYPE.equals(firstDatastoreType)) {
            result.add(VirtualDiskFormat.asDefinedInProfile);
            return result;
        }
        if ((NFS3_TYPE.equalsIgnoreCase(firstDatastoreType) || NFS41_TYPE.equalsIgnoreCase(firstDatastoreType)) && !(acceleration = VmStorageLocatorPropertyProvider.hasAcceleration(dsInfos))) {
            result.add(VirtualDiskFormat.thin);
            return result;
        }
        result.add(VirtualDiskFormat.sameAsSource);
        result.add(VirtualDiskFormat.flat);
        result.add(VirtualDiskFormat.thick);
        result.add(VirtualDiskFormat.thin);
        return result;
    }

    private static boolean hasAcceleration(List<DatastoreInfo> dsInfos) {
        if (dsInfos == null || dsInfos.isEmpty()) {
            return false;
        }
        for (DatastoreInfo dsInfo : dsInfos) {
            if (FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(dsInfo.vStorageSupport)) continue;
            return false;
        }
        return true;
    }

    private Future<AggregatedClusterData> submitClusterDataQuery(final ManagedObjectReference[] contextObjects) {
        final HttpServletRequest httpRequest = SessionUtil.getHttpRequest();
        return this._threadPoolExecutor.submit(new Callable<AggregatedClusterData>(){

            @Override
            public AggregatedClusterData call() throws Exception {
                SessionUtil.setHttpRequest((HttpServletRequest)httpRequest);
                return VmStorageLocatorPropertyProvider.this._aggregatedClusterDataService.queryAggregatedClusterData(contextObjects);
            }
        });
    }
}

