/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VmHardwareVersion
implements Comparable<VmHardwareVersion> {
    private static final Pattern HW_VERSION = Pattern.compile("^vmx-(\\d+)$");
    private int _versionNumber;

    public VmHardwareVersion(String version) throws IncorrectHardwareVersionException {
        this._versionNumber = this.getVersionNumber(version);
        if (this._versionNumber == -1) {
            throw new IncorrectHardwareVersionException(version);
        }
    }

    @Override
    public int compareTo(VmHardwareVersion o) {
        return this._versionNumber - o._versionNumber;
    }

    private int getVersionNumber(String version) {
        Matcher matcher = HW_VERSION.matcher(version);
        return matcher.matches() ? Integer.parseInt(matcher.group(1)) : -1;
    }

    public static class IncorrectHardwareVersionException
    extends Exception {
        public IncorrectHardwareVersionException(String version) {
            super(String.format("Unknown hardware version: %s", version));
        }
    }
}

