/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication.solutionuser;

import com.vmware.ph.ceip.authentication.keystore.VecsKeyStoreProvider;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionUserAuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(SolutionUserAuthenticationConfig.class);
    private final VecsKeyStoreProvider vecsKeystoreProvider = new VecsKeyStoreProvider();
    private final String solutionKeystoreName;
    private final String solutionKeyAlias;
    private PrivateKey solutionKey;
    private X509Certificate solutionCertificate;

    SolutionUserAuthenticationConfig(String solutionKeystoreName, String solutionKeyAlias) {
        this.solutionKeystoreName = solutionKeystoreName;
        this.solutionKeyAlias = solutionKeyAlias;
    }

    public String getSolutionKeystoreName() {
        return this.solutionKeystoreName;
    }

    public String getSolutionKeyAlias() {
        return this.solutionKeyAlias;
    }

    public PrivateKey getSolutionKey() {
        this.initializeOnce();
        return this.solutionKey;
    }

    public X509Certificate getSolutionCertificate() {
        this.initializeOnce();
        return this.solutionCertificate;
    }

    private synchronized void initializeOnce() {
        if (this.solutionKey == null) {
            this.doInitializeConfiguration();
        }
    }

    private void doInitializeConfiguration() {
        char[] keyStorePassword;
        KeyStore keyStore;
        String keyAlias = this.solutionKeyAlias;
        try {
            keyStore = this.vecsKeystoreProvider.loadKeyStore(this.solutionKeystoreName);
            keyStorePassword = new char[]{};
        }
        catch (KeyStoreException e) {
            String exMsg = "Failed to load system wide VECS keystore. This will result in inability for CEIP to collect data and synchronize its consent state accross other VCs. Please file a SR for issue with the Customer Experience Improvement Program (CEIP) For details see the underlying error: " + e.getClass().getName() + ": " + e.getMessage();
            logger.error(exMsg, (Throwable)e);
            throw new RuntimeException(exMsg, e);
        }
        KeyStore.PrivateKeyEntry solutionKeyEntry = SolutionUserAuthenticationConfig.loadSolutionKey(keyStore, keyAlias, keyStorePassword);
        this.solutionKey = solutionKeyEntry.getPrivateKey();
        this.solutionCertificate = (X509Certificate)solutionKeyEntry.getCertificate();
    }

    static boolean isFlagTrueAccordingToWebclientPropertiesStandard(String flagValue) {
        Object[] truths = new String[]{"yes", "on", "true"};
        return ArrayUtils.contains((Object[])truths, (Object)StringUtils.lowerCase((String)flagValue));
    }

    private static KeyStore.PrivateKeyEntry loadSolutionKey(KeyStore keyStore, String keyAlias, char[] keyPassword) {
        try {
            logger.debug("load PrivateKeyEntry for keyAlias: " + keyAlias + " using empty keyPassword.length= " + keyPassword.length);
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword));
            if (!(entry.getCertificate() instanceof X509Certificate)) {
                throw new RuntimeException(String.format("Invalid certificate type for entry `%s' (expected: X.509, got: %s)", keyAlias, entry.getCertificate().getClass().getSimpleName()));
            }
            logger.debug("PrivateKeyEntry loaded successfully for keyAlias: " + keyAlias);
            return entry;
        }
        catch (GeneralSecurityException e) {
            String msg = String.format("Error loading entry `%s' from DS key store: %s", keyAlias, e.getMessage());
            throw new RuntimeException(msg, e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(String.format("Invalid entry type for `%s' (expected: PrivateKeyEntry)", keyAlias));
        }
    }
}

