/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.analytics.local.vapi.client.Audit;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoDomainNotFoundException;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vsphere.client.ceip.exception.DataAgentProxyException;
import java.net.URI;
import java.security.PrivateKey;

public class AuditStubFactory {
    private static final String ANALYTICS_SERVICE_RESPONSE_ERROR = "ceip.dialog.payload.analytics.service.response.error";
    private static final String ANALYTICS_VAPI_URI = "http://localhost:1080/analytics/vapi";
    private static final String TELEMETRY_ENDPOINT_ERROR = "ceip.dialog.payload.telemetry.endpoint.error";

    AuditStubFactory() {
    }

    public Audit createAuditStub() {
        try {
            StubFactory stubFactory = new StubFactory(this.connectProtocol().getApiProvider());
            SamlTokenEx samlTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)SsoDomainHelper.getLocal());
            SamlToken samlToken = samlTokenEx.getToken();
            PrivateKey privateKey = samlTokenEx.getPrivateKey().orElse(null);
            ExecutionContext.SecurityContext samlSecurityContext = SecurityContextFactory.createSamlSecurityContext((SamlToken)samlToken, (PrivateKey)privateKey);
            StubConfiguration stubConfiguration = new StubConfiguration(samlSecurityContext);
            return (Audit)stubFactory.createStub(Audit.class, (StubConfigurationBase)stubConfiguration);
        }
        catch (SsoDomainNotFoundException e) {
            throw new DataAgentProxyException(TELEMETRY_ENDPOINT_ERROR);
        }
    }

    private ProtocolConnection connectProtocol() {
        URI vapiUri = URI.create(ANALYTICS_VAPI_URI);
        ProtocolFactory protocolFactory = new ProtocolFactory();
        ProtocolConnection connection = protocolFactory.getInsecureConnection("http", vapiUri.toString());
        return connection;
    }
}

