/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.vsphere.client.ceip.CeipService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeCeipServiceImpl
implements CeipService {
    private static final Logger _logger = LoggerFactory.getLogger(CompositeCeipServiceImpl.class);
    private final List<CeipService> _ceipServices;
    private CeipService _activeCeipService;

    public CompositeCeipServiceImpl(List<CeipService> ceipServices) {
        this._ceipServices = ceipServices;
    }

    @Override
    public boolean isUserCeipAuthorized() {
        this.initActiveCeipService();
        if (this._activeCeipService == null) {
            return false;
        }
        return this._activeCeipService.isUserCeipAuthorized();
    }

    @Override
    public boolean isCollectionEnabled() {
        this.initActiveCeipService();
        if (this._activeCeipService == null) {
            return false;
        }
        return this._activeCeipService.isCollectionEnabled();
    }

    @Override
    public void setCollectionEnabled(boolean enabled) {
        this.initActiveCeipService();
        if (this._activeCeipService != null) {
            this._activeCeipService.setCollectionEnabled(enabled);
        }
    }

    @Override
    public boolean isActive() {
        this.initActiveCeipService();
        return this._activeCeipService != null;
    }

    private void initActiveCeipService() {
        if (this._activeCeipService != null) {
            return;
        }
        for (CeipService ceipService : this._ceipServices) {
            if (!ceipService.isActive()) continue;
            this._activeCeipService = ceipService;
            break;
        }
        if (this._activeCeipService != null) {
            _logger.debug("The active CeipService is of type: {}", (Object)this._activeCeipService.getClass().getSimpleName());
        } else {
            _logger.warn("There is no avaliable active CeipService!");
        }
    }
}

