/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.analytics.local.vapi.client.Audit;
import com.vmware.analytics.local.vapi.client.AuditTypes;
import com.vmware.vapi.std.errors.AlreadyInDesiredState;
import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vapi.std.errors.NotAllowedInCurrentState;
import com.vmware.vapi.std.errors.ResourceInUse;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vsphere.client.ceip.exception.DataAgentProxyException;
import com.vmware.vsphere.client.ceip.impl.AuditStubFactory;
import com.vmware.vsphere.client.ceip.util.DataValueToJsonConverter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataAppAgentProxy {
    private final AuditStubFactory _auditStubFactory;
    private static final int PH_SERVICE_RETRY_DELAY_MS = 30000;
    private static final int MAX_RETRIES_COUNT = 6;
    private static final String AUDIT_DATA_RETRIEVE_ERROR = "ceip.dialog.payload.audit.data.retrieve.error";
    private static final String ANALYTICS_SERVICE_RESPONSE_ERROR = "ceip.dialog.payload.analytics.service.response.error";
    private static final Log _logger = LogFactory.getLog(DataAppAgentProxy.class);

    public DataAppAgentProxy(AuditStubFactory auditStub) {
        this._auditStubFactory = auditStub;
    }

    public String getAuditData() {
        return this.getClientAuditData(this._auditStubFactory.createAuditStub());
    }

    private String getClientAuditData(Audit auditStub) {
        try {
            try {
                auditStub.audit();
            }
            catch (AlreadyInDesiredState | ResourceInUse e) {
                _logger.info((Object)"Either resource is already in use or proceed with getting result");
            }
            return this.getAuditResult(auditStub);
        }
        catch (Unauthenticated e) {
            throw new DataAgentProxyException(AUDIT_DATA_RETRIEVE_ERROR);
        }
        catch (InternalServerError e) {
            throw new DataAgentProxyException(ANALYTICS_SERVICE_RESPONSE_ERROR);
        }
    }

    private String getAuditResult(Audit auditStub) {
        int retriesCount = 0;
        block6: while (true) {
            try {
                while (true) {
                    AuditTypes.AuditResult auditResult;
                    if ((auditResult = auditStub.get()) != null && auditResult.getStatus() != null && auditResult.getStatus().getEnumValue() == AuditTypes.AuditStatus.Values.DONE) {
                        return DataValueToJsonConverter.dvToJson(auditResult.getResult());
                    }
                    if (++retriesCount > 6) {
                        throw new DataAgentProxyException(ANALYTICS_SERVICE_RESPONSE_ERROR);
                    }
                    try {
                        Thread.sleep(30000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (NotAllowedInCurrentState e) {
                return this.getClientAuditData(auditStub);
            }
            catch (Unauthenticated | IOException e) {
                throw new DataAgentProxyException(AUDIT_DATA_RETRIEVE_ERROR);
            }
            catch (InternalServerError e) {
                throw new DataAgentProxyException(ANALYTICS_SERVICE_RESPONSE_ERROR);
            }
        }
    }
}

