/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapp.impl;

import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vapp.VAppPowerOperation;
import com.vmware.vsphere.client.vapp.VAppPowerOperationSpec;

public class VAppPowerOperations {
    public static OperationResult applyPowerOperation(ManagedObjectReference vAppRef, VAppPowerOperationSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vAppRef;
        try {
            VirtualApp vApp = (VirtualApp)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vAppRef);
            VAppPowerOperation operation = spec.operation;
            if (operation == VAppPowerOperation.powerOn) {
                result.task = vApp.powerOn();
            } else if (operation == VAppPowerOperation.powerOff) {
                result.task = vApp.powerOff(true);
            } else if (operation == VAppPowerOperation.shutdown) {
                result.task = vApp.powerOff(false);
            } else if (operation == VAppPowerOperation.suspend) {
                result.task = vApp.suspend();
            }
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

