/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.cm.InfrastructureNodeInfo;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectReferencePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ObjectReferencePropertyProvider.class);
    private final DataService _dataService;
    private final SsoServiceLocator _ssoServiceLocator;
    private final SsoServiceManager _ssoServiceManager;
    private final CmAuthorizationService _cmAuthorizationService;
    private final ServerPropertyValueExtractor _serverPropertyValueExtractor;
    private final UserSessionService _usService;
    private final LookupService _lookupService;

    public ObjectReferencePropertyProvider(DataService dataService, SsoServiceLocator ssoServiceLocator, CmAuthorizationService cmAuthorizationService, UserSessionService usService, ServerPropertyValueExtractor serverPropertyValueExtractor, SsoServiceManager ssoServiceManager, LookupService lookupService) {
        this._lookupService = lookupService;
        this._dataService = dataService;
        this._ssoServiceLocator = ssoServiceLocator;
        this._cmAuthorizationService = cmAuthorizationService;
        this._usService = usService;
        this._serverPropertyValueExtractor = serverPropertyValueExtractor;
        this._ssoServiceManager = ssoServiceManager;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:adminServer")
    public URI getAdminServer(URI clientInstance) throws Exception {
        SsoDomain localDomain = SsoDomainHelper.getLocal();
        URI adminServiceUri = this._ssoServiceLocator.getSsoServicesFederation(localDomain).getAdminSvcEndpointInfo().getOriginalUri();
        String ssoHostName = adminServiceUri.getHost();
        PropertyConstraint magicalConstraint = QueryUtil.createPropertyConstraint((String)"cm:Server", (String)"hostname", (Comparator)Comparator.EQUALS, (Object)ssoHostName);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)magicalConstraint, (String[])new String[]{"cm.service.getAdminServer"});
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result != null && result.error != null) {
            _logger.error((Object)result.error.getMessage(), (Throwable)result.error);
        }
        if (result == null || ArrayUtils.isEmpty((Object[])result.items)) {
            _logger.info((Object)"SSO Admin Server was not found!");
            return null;
        }
        URI scaURI = (URI)result.items[0].resourceObject;
        return scaURI;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:serviceList")
    public URI[] getVsphereServices(URI clientInstance, Object[] serviceIdsByServerGuids) throws Exception {
        if (ArrayUtils.isEmpty((Object[])serviceIdsByServerGuids) || !this._cmAuthorizationService.isCurrentUserAuthorized()) {
            return new URI[0];
        }
        URI[] result = new URI[serviceIdsByServerGuids.length];
        Map<String, String> hostnamesByGuid = this.getVcHostnamesByGuid();
        for (int i = 0; i < serviceIdsByServerGuids.length; ++i) {
            Pair serviceIdByServerGuid = (Pair)serviceIdsByServerGuids[i];
            Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)serviceIdByServerGuid.first)), (String)"Empty service ID in service URI.");
            Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)serviceIdByServerGuid.second)), (String)"Empty server guid in service URI.");
            String serviceId = (String)serviceIdByServerGuid.first;
            String hostname = hostnamesByGuid.get(serviceIdByServerGuid.second);
            result[i] = "applmgmt".equalsIgnoreCase(serviceId) ? CmReferenceUtil.getServerReference(hostname) : CmReferenceUtil.getServiceReference(serviceId, hostname);
        }
        return result;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isSysAdminPrivilegeGranted")
    public Boolean getIsSysAdminPrivilegeGranted(URI clientInstance) {
        return this._cmAuthorizationService.isCurrentUserAuthorized();
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isCaAdminPrivilegeGranted")
    public Boolean getIsCaAdminPrivilegeGranted(URI clientInstance) {
        return this._cmAuthorizationService.isCaAdminsUser();
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:activeDirectoryInfo")
    public Object getActiveDirectoryInfo(URI clientInstance, InfrastructureNodeInfo serverInfo) {
        InternalServerInfo internalServerInfo = new InternalServerInfo(serverInfo.getHostname(), serverInfo.getDomainController());
        return this._serverPropertyValueExtractor.getValues(new InternalServerInfo[]{internalServerInfo}, new String[]{"activeDirectoryInfo"})[0];
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:infrastructureNodes")
    public Collection<InfrastructureNodeInfo> getSsoNodes(URI clientInstance) throws Exception {
        ArrayList<InfrastructureNodeInfo> ssoServers = new ArrayList<InfrastructureNodeInfo>();
        Collection<InternalServerInfo> servers = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo serverInfo : servers) {
            if (!serverInfo.isDomainController()) continue;
            InfrastructureNodeInfo server = new InfrastructureNodeInfo();
            server.setHostname(serverInfo.getHostname());
            server.setDomainController(serverInfo.isDomainController());
            server.setEncodedHostname(serverInfo.getHostname());
            ssoServers.add(server);
        }
        return ssoServers;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:loggedInVCenter")
    public Map<String, String> getLoggedInVCenter(URI clientInstance) throws Exception {
        String hostId = this._lookupService.getLocalHostId();
        String nodeId = this._lookupService.getLocalHostNodeId();
        HashMap<String, String> vcenterInfo = new HashMap<String, String>();
        if (hostId == null) {
            return null;
        }
        ServiceRegistration.ServiceType scaType = new ServiceRegistration.ServiceType();
        scaType.setProduct("com.vmware.cis");
        scaType.setType("sca");
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setSearchAllSsoDomains(Boolean.valueOf(false));
        filter.setServiceType(scaType);
        ServiceRegistration.Info[] vcServiceInfos = null;
        vcServiceInfos = this._lookupService.getServiceRegistrationInfos(filter);
        if (vcServiceInfos != null) {
            for (ServiceRegistration.Info info : vcServiceInfos) {
                String serviceHostId = LookupUtil.getServiceHostId((ServiceRegistration.Info)info);
                if (!hostId.equals(serviceHostId)) continue;
                if (info.serviceEndpoints[0] != null) {
                    vcenterInfo.put("name", info.serviceEndpoints[0].getUrl().getHost());
                }
                vcenterInfo.put("nodeId", nodeId);
                return vcenterInfo;
            }
        }
        return null;
    }

    private Map<String, String> getVcHostnamesByGuid() {
        ServerInfo[] serverInfos = this._usService.getUserSession().serversInfo;
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ServerInfo si : serverInfos) {
            result.put(si.serviceGuid, si.name);
        }
        return result;
    }
}

