/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.google.common.base.Strings;
import com.vmware.vim.binding.sca.ServiceInstanceContent;
import com.vmware.vim.binding.sca.configuration.ConfigurationUpdate;
import com.vmware.vim.binding.sca.configuration.Parameter;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.configuration.response.ResponseError;
import com.vmware.vim.binding.sca.configuration.response.UpdateResponse;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.impl.VmonServiceControlProvider;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.ScmUtil;
import com.vmware.vsphere.client.security.impl.VCAuthorizationUtil;
import com.vmware.vsphere.client.task.TaskRegistry;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicesMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ServicesMutationProvider.class);
    private static final String[] ADD_PRIVILEGES_ON_START_SERVICE_IDS = new String[]{"imagebuilder"};
    private final ScaServiceManager _scaServiceManager;
    private final VmonServiceControlProvider _vmonControlProvider;
    private final TaskRegistry _clientTaskRegistry;
    private final UserSessionService _userSessionService;

    public ServicesMutationProvider(ScaServiceManager scaServiceManager, VmonServiceControlProvider vmonControlProvider, TaskRegistry clientTaskRegistry, UserSessionService userSessionService) {
        this._scaServiceManager = scaServiceManager;
        this._vmonControlProvider = vmonControlProvider;
        this._clientTaskRegistry = clientTaskRegistry;
        this._userSessionService = userSessionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult apply(URI target, ServiceOperationSpec spec) {
        ClientTaskInfo clientTask = this.createClientTaskInfo(target, spec);
        try {
            clientTask = this._clientTaskRegistry.addTask(clientTask);
            OperationResult result = this._vmonControlProvider.apply(target, spec);
            if (result.error == null && ServicesMutationProvider.shouldInvalidateRolesCache(target, spec)) {
                VCAuthorizationUtil.invalidateRolesCache();
            }
            clientTask.progress = 100;
            if (result.error == null) {
                clientTask.state = TaskState.SUCCESS;
            } else {
                clientTask.state = TaskState.ERROR;
                clientTask.error = result.error;
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        catch (Exception e) {
            clientTask.error = e;
            clientTask.progress = 100;
            clientTask.state = TaskState.ERROR;
            OperationResult result = new OperationResult();
            result.entity = target;
            result.error = e;
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            if (clientTask.progress != 100) {
                clientTask.progress = 100;
            }
            if (clientTask.state != TaskState.SUCCESS && clientTask.state != TaskState.ERROR) {
                clientTask.state = TaskState.SUCCESS;
            }
            clientTask.completionTime = Calendar.getInstance().getTime();
            this._clientTaskRegistry.updateTask(clientTask);
        }
    }

    public OperationResult apply(URI target, ServiceStartupTypeSpec spec) {
        return this._vmonControlProvider.apply(target, spec);
    }

    @MutationMapping(type="cm:Service", property="settings.{resourceKey*}")
    public OperationResult apply(URI target, Map<String, Object> args, @PathParam(value="resourceKey") String resourceKey) {
        OperationResult result = new OperationResult();
        result.entity = target;
        String serviceId = CmReferenceUtil.getId(target);
        if (target == null || args == null || serviceId == null || resourceKey == null) {
            _logger.error((Object)"ServicesMutationProvider: Invalid entity or arguments.");
            result.error = CmUtil.getFault("error.invalidArgument", new String[0]);
            return result;
        }
        Parameter[] parameters = ScmUtil.convertToParameterArray(args);
        if (parameters == null) {
            _logger.error((Object)"ServicesMutationProvider: Null parameters.");
            result.error = CmUtil.getFault("error.invalidArgument", new String[0]);
            return result;
        }
        String serverName = CmReferenceUtil.getServerId(target);
        ScaService scaService = this._scaServiceManager.getService((Object)serverName);
        ServiceInstanceContent sic = scaService.getServiceContent();
        ServiceConfigurationManager scm = (ServiceConfigurationManager)scaService.getManagedObject(sic.configManager);
        ConfigurationUpdate config = new ConfigurationUpdate();
        config.setResourceKey(resourceKey);
        config.setUpdate(parameters);
        try {
            UpdateResponse response = scm.update(serviceId, config);
            result.error = ServicesMutationProvider.getErrorFromResponse(response);
        }
        catch (ServiceManagerFault e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private static MethodFault getErrorFromResponse(UpdateResponse r) {
        if (r.success) {
            return null;
        }
        ResponseError[] errors = r.errors;
        StringBuilder sb = new StringBuilder(CmUtil.getLocalizedString("serviceConfiguration.errors", new String[0]));
        if (errors != null) {
            for (ResponseError e : errors) {
                sb.append("\n");
                if (!Strings.isNullOrEmpty((String)e.getName())) {
                    sb.append(e.getName());
                    sb.append(": ");
                }
                sb.append(CmUtil.getLocalizedMessage(e.getError()));
            }
        }
        return new MethodFault(sb.toString());
    }

    private static boolean shouldInvalidateRolesCache(URI target, ServiceOperationSpec spec) {
        if (!ServiceOperationSpec.Operation.START.equals((Object)spec.operation)) {
            return false;
        }
        String targetServiceId = CmReferenceUtil.getId(target);
        for (String serviceId : ADD_PRIVILEGES_ON_START_SERVICE_IDS) {
            if (!serviceId.equals(targetServiceId)) continue;
            return true;
        }
        return false;
    }

    private ClientTaskInfo createClientTaskInfo(URI target, ServiceOperationSpec spec) {
        ClientTaskInfo clientTask = new ClientTaskInfo();
        clientTask.cancelable = false;
        clientTask.pausable = false;
        clientTask.startTime = Calendar.getInstance().getTime();
        clientTask.entity = target;
        clientTask.progress = 0;
        clientTask.state = TaskState.RUNNING;
        clientTask.entityName = spec.serviceName;
        clientTask.entityType = "cm:Service";
        clientTask.initiator = this._userSessionService.getUserSession().userName;
        clientTask.description = CmUtil.getLocalizedString("serviceAction." + spec.operation.name().toLowerCase(), new String[0]);
        clientTask.taskRef = this.generateTaskReference();
        return clientTask;
    }

    private ManagedObjectReference generateTaskReference() {
        return new ManagedObjectReference("cm:ServiceTask", UUID.randomUUID().toString(), "");
    }
}

