/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.net.URI;

public final class CmReferenceUtil {
    public static final String SERVER_TYPE = "cm:Server";
    public static final String SERVICE_TYPE = "cm:Service";
    private static final int ID_SEGMENT = 0;
    private static final int SERVER_ID_SEGMENT = 1;
    private static final String SERVER_PLACEHOLDER_ID = "__node";

    public static String getId(URI ref) {
        assert (ref != null);
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)ref);
        return segments[0];
    }

    public static String getServerId(URI ref) {
        assert (ref != null);
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)ref);
        if (segments.length <= 1) {
            return "";
        }
        return CmReferenceUtil.decodeString(segments[1]);
    }

    public static URI getServerReference(String hostname) {
        assert (hostname != null);
        String[] segments = new String[]{SERVER_PLACEHOLDER_ID, CmReferenceUtil.encodeString(hostname)};
        return DefaultUriSchemeUtil.createUri((String)SERVER_TYPE, (String[])segments);
    }

    public static URI getServerReference(InternalServerInfo server) {
        assert (server != null);
        return CmReferenceUtil.getServerReference(server.getHostname());
    }

    public static URI getServiceReference(String serviceName, String serverName) {
        assert (serviceName != null);
        assert (serverName != null);
        String[] segments = new String[]{serviceName, CmReferenceUtil.encodeString(serverName)};
        return DefaultUriSchemeUtil.createUri((String)SERVICE_TYPE, (String[])segments);
    }

    public static URI getServiceReference(InternalServiceInfo serviceInfo) {
        assert (serviceInfo != null);
        return CmReferenceUtil.getServiceReference(serviceInfo.getServiceId(), serviceInfo.getServerHostname());
    }

    public static boolean isReferenceOfType(Object reference, String type2, ObjectReferenceService objectReferenceService) {
        assert (type2 != null);
        if (reference == null || !(reference instanceof URI)) {
            return false;
        }
        String uriType = objectReferenceService.getResourceObjectType(reference);
        return type2.equals(uriType);
    }

    private static String decodeString(String str) {
        if (str == null || str.equals("null")) {
            return null;
        }
        byte[] result = Base64.decodeBase64((String)str);
        return new String(result);
    }

    private static String encodeString(String str) {
        if (str == null) {
            return "null";
        }
        String result = Base64.encodeBase64URLSafeString((byte[])str.getBytes());
        return result;
    }
}

