/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.google.common.collect.Sets;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vcenter.services.Service;
import com.vmware.vcenter.services.ServiceTypes;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sso.admin.ComputerManagementService;
import com.vmware.vim.binding.sso.admin.VmHost;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.common.vapi.localization.VapiLocalizationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionHelper;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.ServiceStartupType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CmUtil {
    public static final String VCENTER_SERVICE_TYPE_ID = "vcenterserver";
    public static final String APPLMGMT_SCA_ID = "applmgmt";
    public static final String CLOUDVM_VPXD_SCA_ID = "vmware-vpxd";
    public static final String CISWIN_VPXD_SCA_ID = "vpxd";
    public static final String VPXD_VMON_ID = "vpxd";
    public static final String VSPHERE_CLIENT_SCA_ID = "vsphere-client";
    public static final String HVC_SCA_ID = "vmware-hvc";
    public static final String HVC_VMON_ID = "hvc";
    public static final Set<String> UNHANDLED_PROPERTIES_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"id", "labelIds", "primaryIconId"});
    public static final String NAME_PROP = "name";
    public static final String SERVER_ICON_ID_PROP = "serverIconId";
    public static final String HEALTH_MESSAGES_PROP = "healthMessages";
    public static final String SERVER_NAME_PROP = "serverName";
    public static final String SERVICE_ID_PROP = "serviceId";
    public static final String SERVICE_SHORT_NAME_PROP = "shortName";
    public static final String SERVICE_HEALTH_PROP = "health";
    public static final String SERVICE_STARTUP_TYPE_PROP = "startupType";
    public static final String SERVICE_TYPE_PROP = "serviceType";
    public static final String SERVICE_STATUS_PROP = "status";
    public static final String SERVICE_IS_STARTABLE = "isStartable";
    public static final String SERVICE_IS_STOPPABLE = "isStoppable";
    public static final String SERVICE_IS_RESTARTABLE = "isRestartable";
    public static final String SERVICE_STARTUP_TYPE_EDITABLE_PROP = "startupTypeEditable";
    public static final String SERVICE_AUTO_STARTUP_TYPE_SUPPORTED_PROP = "autoStartupTypeSupported";
    public static final String SERVICE_MANUAL_STARTUP_TYPE_SUPPORTED_PROP = "manualStartupTypeSupported";
    public static final String SERVICE_DISABLED_STARTUP_TYPE_SUPPORTED_PROP = "disabledStartupTypeSupported";
    public static final String SERVICE_DESCRIPTION_PROP = "description";
    public static final String SERVER_PROP = "server";
    public static final String SERVICES_PROP = "services";
    public static final String SERVER_SERVICE_INFOS_PROP = "serviceInfos";
    public static final String SERVER_IS_APPLIANCE_MANAGED_PROP = "isApplianceManaged";
    public static final String SERVER_APPLMGMT_DOWN_PROP = "applmgmtExistsAndDown";
    public static final String SERVER_APPLMGMT_UP_PROP = "applmgmtExistsAndUp";
    public static final String SERVER_IS_UNREACHABLE_PROP = "isUnreachable";
    public static final String SERVER_IS_DOMAIN_CONTROLLER = "isDomainController";
    public static final String VC_SERVICE_ROOT_FOLDER_PROP = "relatedVc";
    public static final String SERVER_APPLMGMT_CONTROL_STATE_PROP = "applmgmtControlState";
    public static final String SERVER_DEPLOYMENT_TYPE_PROP = "deploymentType";
    public static final String SERVER_CONSOLE_CLI_ENABLED_PROP = "consoleCliEnabled";
    public static final String SERVER_DCUI_ENABLED_PROP = "dcuiEnabled";
    public static final String SERVER_SHELL_CONFIG_PROP = "shellConfig";
    public static final String SERVER_SSH_ENABLED_PROP = "sshEnabled";
    public static final String SERVER_CPU_STATS_PROP = "cpuStats";
    public static final String SERVER_MEM_STATS_PROP = "memStats";
    public static final String SERVER_NET_STATS_PROP = "netStats";
    public static final String SERVER_STORAGE_STATS_PROP = "storageStats";
    public static final String SERVER_SYSTEM_HEALTH_PROP = "systemHealth";
    public static final String SERVER_STORAGE_HEALTH_PROP = "storageHealth";
    public static final String SERVER_MEM_HEALTH_PROP = "memHealth";
    public static final String SERVER_LOAD_HEALTH_PROP = "loadHealth";
    public static final String SERVER_DNS_DOMAINS_PROP = "domains";
    public static final String SERVER_HOSTNAME_PROP = "hostname";
    public static final String SERVER_DNS_CONFIG_PROP = "dnsConfig";
    public static final String SERVER_NICS_PROP = "nics";
    public static final String SERVER_IPV4_CONFIG_PROP = "ipv4Config";
    public static final String SERVER_IPV6_CONFIG_PROP = "ipv6Config";
    public static final String SERVER_FIREWALL_RULES_PROP = "firewallRules";
    public static final String SERVER_ROUTES_PROP = "routes";
    public static final String SERVER_SWAP_HEALTH_PROP = "swapHealth";
    public static final String SERVER_UPTIME_PROP = "uptime";
    public static final String SERVER_LOG_MANIFEST_ARRAY = "manifestArray";
    public static final String SERVER_ACTIVE_DIRECTORY_INFO_RPOP = "activeDirectoryInfo";
    public static final String SERVER_ACTIVE_DIRECTORY_JOINED_RPOP = "activeDirectoryJoined";
    public static final String SERVER_SUPPORT_BUNDLE_URL_PROP = "supportBundleUrl";
    public static final String VM_INFO_PROP = "vmInfo";
    public static final long SCA_SERVICE_STATES_QUERY_TIMEOUT = 10L;
    private static final String RESOURCE_BUNDLE_NAME = "ComponentManagerService";
    public static final String SERVER_VMCA_CLIENTS_INITIALIZED_PROPERTY = "isvmcainitialized";
    public static final String SERVER_SYSTEM_VERSION_PROP = "version";
    private static final Log _logger = LogFactory.getLog(CmUtil.class);
    private static final VimSessionHelper vimSessionHelper = VimSessionHelper.getInstance();

    public static MethodFault getFault(String errorMsgKey, String ... args) {
        String errorMsg = CmUtil.getLocalizedString(errorMsgKey, args);
        IllegalArgumentException ex = new IllegalArgumentException(errorMsg);
        MethodFault fault = MixedUtil.getMethodFault((Throwable)ex);
        return fault;
    }

    public static String getLocalizedString(String key, String ... args) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])args, (ClassLoader)CmUtil.class.getClassLoader());
    }

    public static String getServerHostname(ServiceRegistration.Info server) {
        Object ep;
        String hostname = null;
        assert (server != null);
        Object[] endpoints = server.getServiceEndpoints();
        if (ArrayUtils.isEmpty((Object[])endpoints)) {
            _logger.warn((Object)"Unable to get the hostname for server. no endpoints available.");
            return "";
        }
        Object[] objectArray = endpoints;
        int n = objectArray.length;
        for (int i = 0; i < n && !StringUtils.isNotEmpty((CharSequence)(hostname = (ep = objectArray[i]).getUrl().getHost())); ++i) {
        }
        return hostname;
    }

    public static Collection<InternalServiceInfo> getVmonServicesForServer(VapiConnectionManager apiGwBasedVapiConnectionManager, String serverName) {
        return CmUtil.getVmonServicesForServer(apiGwBasedVapiConnectionManager, serverName, null);
    }

    public static Collection<InternalServiceInfo> getVmonServicesForServer(VapiConnectionManager apiGwBasedVapiConnectionManager, String serverName, String[] serviceIds) {
        assert (apiGwBasedVapiConnectionManager != null);
        assert (serverName != null);
        InvocationConfig invConfig = CmUtil.newInvocationConfig(serverName);
        Service vmon = (Service)apiGwBasedVapiConnectionManager.createServiceStub(Service.class);
        Map services = vmon.listDetails(invConfig);
        if (services == null) {
            return Collections.emptyList();
        }
        ArrayList<InternalServiceInfo> result = new ArrayList<InternalServiceInfo>(services.size());
        for (Map.Entry s : services.entrySet()) {
            if (serviceIds != null && !ArrayUtils.contains((Object[])serviceIds, s.getKey())) continue;
            result.add(new InternalServiceInfo((String)s.getKey(), (ServiceTypes.Info)s.getValue(), serverName));
        }
        return result;
    }

    public static ServiceTypes.Info getVmonServiceInfo(VapiConnectionManager apiGwBasedVapiConnectionManager, String serverName, String serviceId) {
        InvocationConfig invConfig;
        try {
            invConfig = CmUtil.newInvocationConfig(serverName);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot create invocation config", (Throwable)ex);
            return null;
        }
        Service vmon = (Service)apiGwBasedVapiConnectionManager.createServiceStub(Service.class);
        if (vmon == null) {
            return null;
        }
        try {
            return vmon.get(serviceId, invConfig);
        }
        catch (NotFound e) {
            return null;
        }
    }

    public static Collection<InternalServerInfo> getServers(SsoServiceManager ssoServiceManager) {
        try {
            ArrayList<InternalServerInfo> servers = new ArrayList<InternalServerInfo>();
            SsoAdminService adminSvc = ssoServiceManager.getAdminService(null, SsoDomainHelper.getLocal());
            ComputerManagementService compMgmt = adminSvc.getComputerManagementService();
            Object[] hosts = compMgmt.getComputers(false);
            for (VmHost host : (VmHost[])ArrayUtils.nullToEmpty((Object[])hosts, VmHost[].class)) {
                InternalServerInfo serverInfo = new InternalServerInfo(host.hostName, host.domainController);
                servers.add(serverInfo);
            }
            return servers;
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot retrieve server nodes", (Throwable)e);
            return new ArrayList<InternalServerInfo>();
        }
    }

    public static ServiceStatus scaCodeToServiceStatus(String code) {
        ServiceStatus result = ServiceStatus.UNKNOWN;
        if (ServiceState.ControlStatus.RUNNING.toString().equalsIgnoreCase(code)) {
            result = ServiceStatus.RUNNING;
        } else if (ServiceState.ControlStatus.STOPPED.toString().equalsIgnoreCase(code)) {
            result = ServiceStatus.STOPPED_NORMAL;
        } else if (ServiceState.ControlStatus.STOPPED_ABNORMAL.toString().equalsIgnoreCase(code)) {
            result = ServiceStatus.STOPPED_ABNORMAL;
        }
        return result;
    }

    public static ServiceStatus vmonCodeToServiceStatus(ServiceTypes.State state) {
        ServiceStatus result = ServiceStatus.UNKNOWN;
        if (ServiceTypes.State.STARTED.equals((Object)state)) {
            result = ServiceStatus.RUNNING;
        } else if (ServiceTypes.State.STARTING.equals((Object)state)) {
            result = ServiceStatus.RUNNING;
        } else if (ServiceTypes.State.STOPPED.equals((Object)state)) {
            result = ServiceStatus.STOPPED_NORMAL;
        } else if (ServiceTypes.State.STOPPING.equals((Object)state)) {
            result = ServiceStatus.RUNNING;
        }
        return result;
    }

    public static String[] extractHealthMessages(ServiceState scaStatus) {
        com.vmware.vim.binding.vmodl.LocalizableMessage[] messages;
        com.vmware.vim.binding.vmodl.LocalizableMessage[] localizableMessageArray = messages = scaStatus != null ? scaStatus.healthMessages : null;
        if (messages != null && messages.length > 0) {
            String[] localizedMessages = new String[messages.length];
            for (int j = 0; j < messages.length; ++j) {
                localizedMessages[j] = LocalizationUtil.getLocalizedMessage((String)messages[j].getKey(), (KeyAnyValue[])messages[j].getArg());
            }
            return localizedMessages;
        }
        return null;
    }

    public static String[] extractHealthMessages(ServiceTypes.Info info) {
        List messages;
        List list = messages = info != null ? info.getHealthMessages() : null;
        if (messages != null && messages.size() > 0) {
            String[] localizedMessages = new String[messages.size()];
            for (int j = 0; j < messages.size(); ++j) {
                localizedMessages[j] = VapiLocalizationUtil.getLocalizedMessage((LocalizableMessage)((LocalizableMessage)messages.get(j)));
            }
            return localizedMessages;
        }
        return null;
    }

    public static HealthState healthStateFromScaHealthStatus(String healthStatus) {
        HealthState result = HealthState.UNKNOWN;
        if (StringUtils.isEmpty((CharSequence)healthStatus)) {
            result = HealthState.UNSUPPORTED;
        } else if (ServiceState.HealthStatus.GREEN.toString().equalsIgnoreCase(healthStatus)) {
            result = HealthState.GOOD;
        } else if (ServiceState.HealthStatus.YELLOW.toString().equalsIgnoreCase(healthStatus)) {
            result = HealthState.WARNING;
        } else if (ServiceState.HealthStatus.RED.toString().equalsIgnoreCase(healthStatus)) {
            result = HealthState.CRITICAL;
        } else if (ServiceState.HealthStatus.HEALTH_UNKNOWN.toString().equalsIgnoreCase(healthStatus)) {
            result = HealthState.UNKNOWN;
        }
        return result;
    }

    public static HealthState healthStateFromVmonHealthStatus(ServiceTypes.Health health) {
        HealthState result = HealthState.UNKNOWN;
        if (health == null) {
            result = HealthState.UNSUPPORTED;
        } else if (health.equals((Object)ServiceTypes.Health.HEALTHY)) {
            result = HealthState.GOOD;
        } else if (health.equals((Object)ServiceTypes.Health.HEALTHY_WITH_WARNINGS)) {
            result = HealthState.WARNING;
        } else if (health.equals((Object)ServiceTypes.Health.DEGRADED)) {
            result = HealthState.CRITICAL;
        }
        return result;
    }

    public static ServiceStartupType serviceStartupTypeFromScaStartupType(StartupType scaStartupType) {
        ServiceStartupType result = ServiceStartupType.UNKNOWN;
        if (scaStartupType != null) {
            if (ServiceStartupType.AUTOMATIC.toString().equalsIgnoreCase(scaStartupType.choice)) {
                result = ServiceStartupType.AUTOMATIC;
            } else if (ServiceStartupType.MANUAL.toString().equalsIgnoreCase(scaStartupType.choice)) {
                result = ServiceStartupType.MANUAL;
            } else if (ServiceStartupType.DISABLED.toString().equalsIgnoreCase(scaStartupType.choice)) {
                result = ServiceStartupType.DISABLED;
            }
        }
        return result;
    }

    public static ServiceStartupType serviceStartupTypeFromVmonStartupType(ServiceTypes.StartupType vmonStartupType) {
        ServiceStartupType result = ServiceStartupType.UNKNOWN;
        if (ServiceTypes.StartupType.AUTOMATIC.equals((Object)vmonStartupType)) {
            result = ServiceStartupType.AUTOMATIC;
        } else if (ServiceTypes.StartupType.MANUAL.equals((Object)vmonStartupType)) {
            result = ServiceStartupType.MANUAL;
        } else if (ServiceTypes.StartupType.DISABLED.equals((Object)vmonStartupType)) {
            result = ServiceStartupType.DISABLED;
        }
        return result;
    }

    public static String getLocalizedMessage(com.vmware.vim.binding.vmodl.LocalizableMessage localizableMessage) {
        assert (localizableMessage != null);
        String result = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
        if (StringUtils.equals((CharSequence)result, (CharSequence)localizableMessage.getKey())) {
            result = localizableMessage.getMessage();
        }
        return result;
    }

    public static MethodFault transformVapiError(Error e) {
        assert (e != null);
        MethodFault result = new MethodFault();
        List messages = e.getMessages();
        if (messages != null) {
            List localizedMessages = VapiLocalizationUtil.getLocalizedMessages((List)messages);
            result.setMessage(StringUtils.join((Iterable)localizedMessages, (String)"\n"));
        } else {
            result.setMessage(e.getMessage());
        }
        result.initCause((Throwable)e);
        return result;
    }

    public static InvocationConfig newInvocationConfig(String hostName) {
        Validate.notNull((Object)hostName);
        LinkedVcGroupRegistry linkedVcGroupRegistry = vimSessionHelper.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroups = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            throw new IllegalStateException(String.format("Cannot find node id for host '%s' because the LinkedVcGroups are null.", hostName));
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            String nodeId = linkedVcGroup.findNodeIdByHostName(hostName);
            if (nodeId == null) continue;
            return VapiUtil.newInvocationConfig((String)nodeId);
        }
        throw new IllegalStateException(String.format("Cannot find node id for host '%s' because couldn't find matching service endpoint.", hostName));
    }
}

