var WEBSSO_REDIRECT_PATH = 'login/websso';
var IDP_LOCAL = 'local';
var loginMessageTitle;
var loginMessageContent;
var loginMessageConsentEnabled = false;
var loginMessageAlertMessage = 'In order to use our services, you must agree to';
var usernameRequireErrorMessage = 'Username is required.';
var usernameFormatErrorMessage = 'Invalid username.';

$(document).ready(function() {
   initialize();
});

function initialize() {
   updatePage();
   getLoginPageConfig();
}

function getLoginPageConfig() {
   $.ajax({
      url: 'discovery/config',
      type: "GET",
      success: getLoginPageConfigSuccess,
      error: getLoginPageConfigFailure
   });
}

function getLoginPageConfigSuccess(config) {
   var isAuthenticated = config.hasUserSession === 'true';
   // if session exist redirect to /ui
   redirectIfAuthenticated(isAuthenticated);

   // localization
   loginMessageConsentEnabled = config['loginMessageConsentEnabled'] === 'true';
   loginMessageTitle = config['loginMessageTitle'];
   loginMessageContent = config['loginMessageContent'];
   $('#nextBtn').text(config['discovery.next']);
   $('#username').prop('placeholder',config['discovery.username.placeholder']);
   $('#redirectToIdpText').text(config['discovery.redirect.info']);
   $('#agreementMsg').text(config['discovery.consent.agree.to']);
   $('.instruction').text(config['discovery.username.label']);
   loginMessageAlertMessage = config['discovery.consent.alert'];
   usernameRequireErrorMessage = config['discovery.username.required'];
   usernameFormatErrorMessage = config['discovery.username.format'];

   setLoginMessage();
   setBrandname(config);

   $('#loginWrapper').css('display', 'flex');
   $('#loadingContainer').css('display', 'none');
   $('#username').focus();
}

function getLoginPageConfigFailure(response) {
   var errorMessage = response.status + ' ' + response.statusText;
   console.error('Error: failed to fetch page config values - ' +  errorMessage);
   $('#loadingContainer').css('display', 'none');
   $('#loginWrapper').css('display', 'flex');
   setLoginMessage();
}

function updatePage() {
   $('#loadingContainer').css('display', 'block');
   $('#loginWrapper').css('display', 'none');
   $('#dialogLogonBanner').css('display', 'none');
   $('#tenantBrand').css('display', 'none');
   $('#redirectToIdp').css('display', 'none');
   $('#infoID').css('display', 'none');
   $('#usernameError').css('display', 'none');
   $('#username').on( "keydown", function handle(e) {
      // Handle enter key event (13)
      if (e.keyCode === 13) {
         e.preventDefault();
         startValidateUser();
      }
   });
   $('#username').on('input', function () {
      hideErrors();
      enableNextButton();
   });
   showProgress(false);
}

function getIdpDetails(domain) {
   $.ajax({
      url: 'discovery/idp/' + encodeURIComponent(domain),
      type: "GET",
      success: getIdpDetailsSuccess,
      error: getIdpDetailsFailure
   });
}

function validateUser() {
   var username = $.trim($('#username').val());
   var usernameParts = username.split('@');
   var domain;
   if (usernameParts.length == 2) {
      domain = usernameParts[1]
   }
   if (!isEmptyString(domain)) {
      getIdpDetails(domain);
   } else {
      // default to websso
      redirectToIdp(IDP_LOCAL, WEBSSO_REDIRECT_PATH);
   }
}

function getIdpDetailsSuccess(response) {
   var idp = response && response.idp;
   var redirectPath = response && response.redirectPath;
   redirectToIdp(idp, redirectPath);
}

function getIdpDetailsFailure(response) {
   var errorMessage = response.status + ' ' + response.statusText;
   console.error('Error: failed to check users idp - ' + errorMessage);
   // default to websso
   redirectToIdp(IDP_LOCAL, WEBSSO_REDIRECT_PATH);
}


function redirectToIdp(idp, redirectPath) {
   if (isEmptyString(idp) || isEmptyString(redirectPath)) {
      console.error("Unable to determine user's idp")
      showErrorMsg(usernameFormatErrorMessage);
      showProgress(false);
      disableNextButton();
      focusUsernameInput();
      return;
   }
   if (idp !== IDP_LOCAL) {
      $('#redirectToIdp').css('display', 'flex');
      $('#loginWrapper').css('display', 'none');
      window.location.href = redirectPath;
   } else {
      window.location.href = redirectPath + getQueryParamsForWebsso();
   }
}

function  getQueryParamsForWebsso() {
   var username = $.trim($('#username').val());
   var queryParams = '';
   if (!isEmptyString(username)) {
      queryParams = queryParams + '?prefilledUsername=' + username;
      if (loginMessageConsentEnabled) {
         queryParams = queryParams + '&' + 'isConsentChecked=true';
      }
      queryParams = queryParams + '&' + 'discovery=true';
   }
   return queryParams;
}

function redirectIfAuthenticated(isAuthenticated) {
   if (isAuthenticated) {
      window.location.href = '/ui/';
   }
}

function startValidateUser() {
   username = $.trim($('#username').val());
   if (username === '') {
      showErrorMsg(usernameRequireErrorMessage);
      disableNextButton();
      focusUsernameInput();
      return;
   }
   var usernameParts = username.split('@');
   if (usernameParts.length !== 2 || isEmptyString(usernameParts[0]) || isEmptyString(usernameParts[1])) {
      showErrorMsg(usernameFormatErrorMessage);
      disableNextButton();
      focusUsernameInput();
      return;
   }
   if(isLogonBannerEnabled() && loginMessageConsentEnabled && !isBannerChecked()) {
      return;
   }
   showProgress(true);
   validateUser();
}

function displayLogonBannerDialog() {
   $('#dialogLogonBanner').css('display', 'block');
   $('#dialogLogonBannerTitle').html(loginMessageTitle);
   $('#dialogContentText').html(loginMessageContent);
   $('#dialogLogonBanner').dialog(
      {
         width: 650,
         height: 400,
         modal: true,
         draggable: false
      }
   );
   $('.ui-dialog-titlebar').html('<span class="close-button"><img src="static/resources10880725/img/close.png" /></span>');
   $('.close-button').click(function () {
      $('#dialogLogonBanner').dialog("close");
      $('#dialogLogonBanner').css('display', 'none');
   });
}

function isLogonBannerEnabled() {
   return !isEmptyString(loginMessageTitle) && !isEmptyString(loginMessageContent)
}

function isBannerChecked() {
   if ($('#logonBannerCheckbox').prop('checked')) {
      clearInfoText();
      return true;
   } else {
      var alertMsg = loginMessageAlertMessage + " " + loginMessageTitle;
      showInfoText(alertMsg);
      return false;
   }
}

function setLoginMessage() {
   if (isLogonBannerEnabled()) {
      $('#logonBannerID #logonBannerTitle').html(loginMessageTitle);
      $('#logonMessageDiv #logonBannerTitle').html(loginMessageTitle);
      if (!loginMessageConsentEnabled) {
         // hide checkbox and agreementMsg if checkbox is not enabled
         $('#logonBannerID').hide();
         $('#logonMessageDiv').show();
      }
      else {
         $('#logonBannerID').show();
         $('#logonMessageDiv').hide();
      }
   } else {
      $('#logonBannerID').hide();
      $('#logonMessageDiv').hide();
   }
}

function setBrandname(config) {
   const brandname = config["brandname"];
   if (!isEmptyString(brandname)) {
      $('#titleVmware').css('display', 'none');
      $('#tenantBrand').html(brandname);
      $('#tenantBrand').css('display', 'block');
   }
}

function showInfoText(message) {
   $('#infoID').css('display', 'block');
   $('#infoText').text(message);
}

function clearInfoText() {
   $('#infoID').css('display', 'none');
   $('#infoText').text('');
}

function showProgress(doStart) {
   if (doStart == true) {
      $('#nextBtn').css('display', 'none');
      $('#progressBar').css('display', 'block');
      $('#username').prop('disabled', true);
   } else {
      $('#nextBtn').css('display', 'block');
      $('#progressBar').css('display', 'none');
      $('#username').prop('disabled', false);
   }
}

function enableNextButton() {
   $('#nextBtn').prop('disabled', false);
}

function disableNextButton() {
   $('#nextBtn').prop('disabled', true);
}

function showErrorMsg(msg) {
   $('#usernameError').text(msg);
   $('#usernameError').addClass('error active');
   $('#usernameError').css('display', 'flex');
}

function hideErrors() {
   $('#usernameError').removeClass('error active');
   $('#usernameError').css('display', 'none');
}

function focusUsernameInput() {
   $('#username').focus();
}

function isEmptyString(data) {
   // checks for null, undefined, '' and ""
   if (typeof data === 'string') {
      if (!data) {
         return true;
      };
      return data.length === 0;
   }
   return true;
}

