// WEB_PLATFORM is the VMware Web Client platform reference:
// - When the plugin runs in the HTML client WEB_PLATFORM is a real JS object
// - When it runs in the Flex client WEB_PLATFORM is defined as the Flash container

+function() {

   var WEB_PLATFORM_PARENT = self.parent.WEB_PLATFORM;
   //Not valid for real case scenarios, since this if to be loaded in an iframe
   if (!WEB_PLATFORM_PARENT) {
      return;
   }
   var WEB_PLATFORM = Object.create(WEB_PLATFORM_PARENT);

   window.WEB_PLATFORM = WEB_PLATFORM;


   // -------------------------- Public APIs --------------------------------


   // Get the current context object id or return null if none is defined
   WEB_PLATFORM.getObjectId = function() {
      return getURLParameter("objectId");
   };
   // Get the current action Uid or return null if none is defined
   WEB_PLATFORM.getActionUid = function() {
      return getURLParameter("actionUid");
   };
   // Get the comma-separated list of object ids for an action, or null for a global action
   WEB_PLATFORM.getActionTargets = function() {
      return getURLParameter("targets");
   };
   // Get the current locale
   WEB_PLATFORM.getLocale = function() {
      return getURLParameter("locale");
   };

   // Get the info provided in a global view using a vCenter selector
   WEB_PLATFORM.getVcSelectorInfo = function() {
      var info = {
         serviceGuid: getURLParameter("serviceGuid"),
         sessionId: getURLParameter("sessionId"),
         serviceUrl: getURLParameter("serviceUrl")
      };
      return info;
   };

   // Set the global refresh handler called when the user hits Refresh
   // in the WebClient top toolbar
   WEB_PLATFORM.setGlobalRefreshHandler = function(handler) {
      //TODO: use another mechanism for h5
      WEB_PLATFORM_PARENT["refresh" + window.name] = handler;
   };

   //expose a method needed to build compatibility to plugin specific WEB_PLATFORM
   WEB_PLATFORM.initPlugin = initPlugin;


   // ------------------------ Private functions -------------------------------

   //creates a name space object and adds some helper methods
   function initPlugin(config) {

      if (!config || !config.pluginName || !config.pluginPackageName) {
         throw "Config object with 'pluginName' & ''pluginPackageName properties is missing";
      }

      var pluginName = config.pluginName;
      var pluginPackageName = config.pluginPackageName;

      var pluginNameSpace = {};

      // Functions exported to the __PLUGIN__ namespace
      pluginNameSpace.getString = getString;
      pluginNameSpace.buildDataUrl = buildDataUrl;
      pluginNameSpace.webContextPath = WEB_PLATFORM.getRootPath() + '/' + pluginName;


      //expose to the windows object
      window[pluginPackageName] = pluginNameSpace;

      // Build the REST url prefix to retrieve a list of properties,
      // this is mapped to the DataAccessController on the java side.
      function buildDataUrl(objectId, propList) {
         var propStr = propList.toString();
         var dataUrl = pluginNameSpace.webContextPath +
            "/rest/data/properties/" + objectId + "?properties=" + propStr;
         return dataUrl;
      }

      // Get a string from the resource bundle defined in plugin.xml
      function getString(key, params) {
         return WEB_PLATFORM.getString(pluginPackageName, key, params);
      }

   };

   // Get a parameter value from the current document URL
   function getURLParameter(name) {
      return (new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)')
            .exec(location.href) || [, ""])[1].replace(/\+/g, '%20') || null;
   }


}();
