/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.messaging.AbsoluteDataValuesProvider;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.UpdatesManager;
import com.vmware.vise.vim.messaging.context.support.ClientIdHolder;
import com.vmware.vise.vim.messaging.websocket.Controller;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.List;
import java.util.Map;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;

public class LiveUpdatesSubscriptionController
implements Controller {
    private static final Log _logger = LogFactory.getLog(LiveUpdatesSubscriptionController.class);
    private final Map<String, List<AbsoluteDataValuesProvider<?>>> _absoluteDataValuesProvidersByDestination;
    private final ObjectFactory<UpdatesManager> _updatesManagerFactory;
    private final ObjectFactory<MessageSender> _messageSenderFactory;
    private static final String OPEN_INVENTORY = "OPEN_INVENTORY";
    private static final String CLOSE_INVENTORY = "CLOSE_INVENTORY";

    public LiveUpdatesSubscriptionController(Map<String, List<AbsoluteDataValuesProvider<?>>> map, ObjectFactory<UpdatesManager> objectFactory, ObjectFactory<MessageSender> objectFactory2) {
        this._absoluteDataValuesProvidersByDestination = map;
        this._updatesManagerFactory = objectFactory;
        this._messageSenderFactory = objectFactory2;
    }

    public Object handleRequest(String string, Session session) {
        String string2 = string;
        if (this.isListenerChange(string2)) {
            return this.changeListener(string2);
        }
        return this.subscribe(string2, session);
    }

    private Object changeListener(String string) {
        Object[] objectArray = string.split(":");
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length < 2) {
            return null;
        }
        Object object = objectArray[1];
        if (StringUtil.isNullOrEmpty((String)object)) {
            return null;
        }
        UpdatesManager updatesManager = (UpdatesManager)this._updatesManagerFactory.getObject();
        if (string.startsWith(OPEN_INVENTORY)) {
            updatesManager.openInventory((String)object);
            return null;
        }
        if (string.startsWith(CLOSE_INVENTORY)) {
            updatesManager.closeInventory((String)object);
        }
        return null;
    }

    private Object subscribe(String string, Session session) {
        Object[] objectArray = string.split("destination:");
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length < 2) {
            _logger.error((Object)"Request is not in the expected format.");
            return null;
        }
        Object object = objectArray[1];
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Initializing Live Updates Pipeline ..." + (String)object));
        }
        final String string2 = ClientIdHolder.getClientId();
        ((UpdatesManager)this._updatesManagerFactory.getObject()).subscribe((String)object, new Runnable((String)object, session){
            final /* synthetic */ String val$destination;
            final /* synthetic */ Session val$session;
            {
                this.val$destination = string22;
                this.val$session = session;
            }

            @Override
            public void run() {
                ClientIdHolder.setClientId((String)string2);
                try {
                    PartialUpdate partialUpdate = LiveUpdatesSubscriptionController.this.getAvailableDataValuesByDestination(this.val$destination);
                    if (partialUpdate == null || partialUpdate.isEmpty()) {
                        return;
                    }
                    partialUpdate.destination = this.val$destination;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Available absolute values for " + this.val$destination + " are retrieved!"));
                    }
                    ((MessageSender)LiveUpdatesSubscriptionController.this._messageSenderFactory.getObject()).sendToSession((Object)partialUpdate, this.val$session);
                }
                finally {
                    ClientIdHolder.resetClientId();
                }
            }
        });
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Live Updates " + (String)object + " is ready!"));
        }
        return null;
    }

    private boolean isListenerChange(String string) {
        return string.startsWith(OPEN_INVENTORY) || string.startsWith(CLOSE_INVENTORY);
    }

    private PartialUpdate<?> getAvailableDataValuesByDestination(String string) {
        List<AbsoluteDataValuesProvider<?>> list = this._absoluteDataValuesProvidersByDestination.get(string);
        AbsoluteDataValuesProvider<Object> absoluteDataValuesProvider = null;
        absoluteDataValuesProvider = list == null || list.isEmpty() ? new AbsoluteDataValuesProvider<Object>(){

            public PartialUpdate<Object> getAvailableDataValues() {
                return PartialUpdate.empty();
            }
        } : list.get(0);
        PartialUpdate partialUpdate = absoluteDataValuesProvider.getAvailableDataValues();
        return partialUpdate;
    }
}

