/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.LiveRefreshFeatureSwitch;
import com.vmware.vise.vim.messaging.UserState;
import com.vmware.vise.vim.messaging.cdc.ChangeLogService;
import com.vmware.vise.vim.messaging.pollers.AlarmIssuePollerFactory;
import com.vmware.vise.vim.messaging.pollers.Poller;
import com.vmware.vise.vim.messaging.pollers.PropertyCollectorPollerFactory;
import com.vmware.vise.vim.messaging.pollers.TaskRegistryPoller;
import com.vmware.vise.vim.messaging.propcollector.FilterRegistry;
import com.vmware.vise.vim.messaging.propcollector.PropertyCollectorService;
import com.vmware.vise.vim.messaging.updates.MutationOperationUpdatesHandler;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

public final class UpdatesManager
implements DisposableBean {
    private static final Log _logger = LogFactory.getLog(UpdatesManager.class);
    private final UserState _userState;
    private final PropertyCollectorService _propertyCollectorService;
    private final ChangeLogService _changeLogService;
    private final PropertyCollectorPollerFactory _propertyCollectorPoller;
    private final TaskRegistryPoller _taskRegistryPoller;
    private final AlarmIssuePollerFactory _alarmIssuePollerFactory;
    private final MutationOperationUpdatesHandler _mutationOperationUpdatesHandler;
    private final MessageSender _messageSender;
    private final boolean _useLongPollingForRecentTasks;
    private final LiveRefreshFeatureSwitch _featureSwitch;
    private final List<Poller> _pollers = new CopyOnWriteArrayList<Poller>();
    private final AtomicBoolean _updatesStopped = new AtomicBoolean(true);

    public UpdatesManager(PropertyCollectorService propertyCollectorService, ChangeLogService changeLogService, UserState userState, PropertyCollectorPollerFactory propertyCollectorPollerFactory, TaskRegistryPoller taskRegistryPoller, AlarmIssuePollerFactory alarmIssuePollerFactory, MutationOperationUpdatesHandler mutationOperationUpdatesHandler, MessageSender messageSender, boolean bl, LiveRefreshFeatureSwitch liveRefreshFeatureSwitch) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyCollectorService, changeLogService, userState, propertyCollectorPollerFactory, taskRegistryPoller, alarmIssuePollerFactory, mutationOperationUpdatesHandler, messageSender, liveRefreshFeatureSwitch});
        this._propertyCollectorService = propertyCollectorService;
        this._changeLogService = changeLogService;
        this._userState = userState;
        this._propertyCollectorPoller = propertyCollectorPollerFactory;
        this._taskRegistryPoller = taskRegistryPoller;
        this._alarmIssuePollerFactory = alarmIssuePollerFactory;
        this._mutationOperationUpdatesHandler = mutationOperationUpdatesHandler;
        this._messageSender = messageSender;
        this._useLongPollingForRecentTasks = bl;
        this._featureSwitch = liveRefreshFeatureSwitch;
    }

    public void openInventory(String string) {
        this._changeLogService.openInventory(string);
    }

    public void closeInventory(String string) {
        this._changeLogService.closeInventory(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String string, final Runnable runnable) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, runnable});
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
                if (httpServletRequest == null) {
                    SessionUtil.setHttpRequest((HttpServletRequest)UpdatesManager.this._userState.getRequest());
                }
                try {
                    runnable.run();
                }
                finally {
                    if (httpServletRequest == null) {
                        SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                    }
                }
            }
        };
        AtomicInteger atomicInteger = new AtomicInteger(1);
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            SessionUtil.setHttpRequest((HttpServletRequest)this._userState.getRequest());
        }
        try {
            if (this._updatesStopped.compareAndSet(true, false)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"LiveRefresh resubscribe.");
                }
                try {
                    if (!this._useLongPollingForRecentTasks && this._featureSwitch.propertyCollectorRecentTasksEnabled()) {
                        this.createPropertyCollectorPollers();
                    }
                    this.createAlarmIssuePoller();
                    this._taskRegistryPoller.addUpdateHandler(this._messageSender);
                }
                catch (Exception exception) {
                    _logger.error((Object)"Error initializing pollers", (Throwable)exception);
                }
            }
            if (this._featureSwitch.propertyCollectorRecentTasksEnabled()) {
                if (this._useLongPollingForRecentTasks) {
                    this._propertyCollectorService.subscribe(string, atomicInteger, runnable2);
                } else {
                    this.createPropertyCollectorFilters(string);
                }
            }
            if (this._featureSwitch.changeLogEnabled()) {
                this._changeLogService.subscribe(string, atomicInteger, runnable2);
            }
        }
        finally {
            if (httpServletRequest == null) {
                SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
            }
        }
        if (atomicInteger.decrementAndGet() == 0) {
            runnable2.run();
        }
    }

    public void init() {
        SessionUtil.setHttpRequest((HttpServletRequest)this._userState.getRequest());
        try {
            this._messageSender.onClose(new Runnable(){

                @Override
                public void run() {
                    UpdatesManager.this.unsubscribe();
                }
            });
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        if (this._updatesStopped.compareAndSet(false, true)) {
            _logger.info((Object)"Cancelling updates");
            HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
            SessionUtil.setHttpRequest((HttpServletRequest)this._userState.getRequest());
            try {
                this._propertyCollectorService.unsubscribe();
                this._changeLogService.unsubscribe();
                this._taskRegistryPoller.removeUpdateHandler(this._messageSender);
                this._mutationOperationUpdatesHandler.removeHandler(this._messageSender);
                for (Poller poller : this._pollers) {
                    try {
                        poller.stop();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"Error stopping poller:", (Throwable)exception);
                    }
                }
                this._pollers.clear();
            }
            finally {
                SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
            }
        }
    }

    public void destroy() {
        this._taskRegistryPoller.removeUpdateHandler(this._messageSender);
        this._mutationOperationUpdatesHandler.removeHandler(this._messageSender);
    }

    private void createPropertyCollectorPollers() {
        Set<VcService> set = this._userState.getVcServices();
        if (set.isEmpty()) {
            _logger.error((Object)"[LiveRefresh] No Property Collector Streams were created becuase userVCs is empty.");
            return;
        }
        try {
            for (VcService vcService : set) {
                Poller poller = this._propertyCollectorPoller.createPoller(this._userState.getHashedClientId(), this._userState.getRequest(), vcService, this._propertyCollectorService.filterRegistry);
                poller.setHandler(this._messageSender);
                poller.start();
                this._pollers.add(poller);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Property Collector Pollers failed to be created", (Throwable)exception);
        }
    }

    private void createAlarmIssuePoller() {
        try {
            boolean bl;
            boolean bl2 = this._featureSwitch.alarmsEnabled();
            boolean bl3 = bl = !this._featureSwitch.alarmsPcBasedUpdateEnabled();
            if (bl2 && bl) {
                Poller poller = this._alarmIssuePollerFactory.createPoller(this._userState.getRequest());
                poller.setHandler(this._messageSender);
                poller.start();
                this._pollers.add(poller);
                this._mutationOperationUpdatesHandler.addHandler(this._messageSender);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Alarms Stream failed to be created");
        }
    }

    private void createPropertyCollectorFilters(final String string) {
        final FilterRegistry filterRegistry = this._propertyCollectorService.filterRegistry;
        Set<VcService> set = this._userState.getVcServices();
        final HashMap<VcService, PropertyCollector.FilterSpec> hashMap = new HashMap<VcService, PropertyCollector.FilterSpec>();
        for (VcService vcService : set) {
            if (!filterRegistry.registerFilter(vcService.getServiceGuid(), string)) continue;
            for (UpdatesProcessor<?> updatesProcessor : this._propertyCollectorService.updatesProcessors) {
                PropertyCollector.FilterSpec filterSpec = updatesProcessor.createFilterSpec(string, vcService);
                if (filterSpec == null) continue;
                hashMap.put(vcService, filterSpec);
            }
        }
        if (hashMap.isEmpty()) {
            return;
        }
        this._propertyCollectorService.liveRefreshWorker.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
                SessionUtil.setHttpRequest((HttpServletRequest)UpdatesManager.this._userState.getRequest());
                try {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        VcService vcService = (VcService)entry.getKey();
                        PropertyCollector.FilterSpec filterSpec = (PropertyCollector.FilterSpec)entry.getValue();
                        PropertyCollector propertyCollector = (PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().getPropertyCollector());
                        ManagedObjectReference managedObjectReference = propertyCollector.createFilter(filterSpec, true);
                        filterRegistry.add(managedObjectReference, string);
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)"[LiveRefresh] Unable to register PC filter: ", (Throwable)exception);
                }
                finally {
                    SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                }
            }
        });
    }
}

