/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.google.common.base.Optional;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.query.InvalidCollectorVersion;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.vim.messaging.Update;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatesProvider {
    private static final String INITIAL_VERSION = "";
    private static final Log _logger = LogFactory.getLog(UpdatesProvider.class);
    private PropertyCollector pc;
    private String version = "";
    private String pcServerGuid;
    private boolean isAlive;

    public UpdatesProvider(PropertyCollector propertyCollector) {
        this.pc = propertyCollector;
        this.pcServerGuid = propertyCollector._getRef().getServerGuid();
        this.isAlive = true;
    }

    public Optional<Update> checkForUpdates() throws InvalidCollectorVersion, NotAuthenticated {
        if (!this.isAlive) {
            return Optional.absent();
        }
        PropertyCollector.UpdateSet updateSet = this.pc.checkForUpdates(this.version);
        if (updateSet == null) {
            return Optional.absent();
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)String.format("[LiveRefresh] Thread id: [%d] received UpdateSet: %s", Thread.currentThread().getId(), updateSet));
        }
        this.version = updateSet.version;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("[LiveRefresh] PropertyCollector returned an update with version: " + this.version));
        }
        long l = System.currentTimeMillis();
        Update update = new Update(updateSet, l);
        return Optional.of((Object)update);
    }

    public synchronized void reset() {
        _logger.info((Object)("[LiveRefresh] UpdatesProvider version reset: " + this.pc + " " + this.pcServerGuid));
        this.version = INITIAL_VERSION;
    }

    public String getPCguid() {
        return this.pcServerGuid;
    }

    public synchronized void suspend() {
        if (!this.isAlive) {
            _logger.warn((Object)"[LiveRefresh] Suspending an already suspended UpdatesProvider.");
        }
        this.isAlive = false;
        _logger.info((Object)("[LiveRefresh] UpdatesProvider was suspended: " + this.pc + " " + this.pcServerGuid));
    }

    public synchronized void restore(PropertyCollector propertyCollector) {
        if (this.isAlive) {
            _logger.warn((Object)"[LiveRefresh] Restoring a property collector, which was not suspended.");
        }
        _logger.info((Object)("[LiveRefresh] UpdatesProvider was restored with a new PC: " + propertyCollector + " " + this.pcServerGuid + " filters: " + Arrays.toString(propertyCollector.getFilter())));
        this.isAlive = true;
        this.pc = propertyCollector;
        this.pcServerGuid = propertyCollector._getRef().getServerGuid();
    }
}

