/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.util.WebUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserState {
    private final LinkedVcGroupRegistry _linkedVcGroupRegistry;
    private String _clientId;
    private String _hashedClientId;
    private HttpServletRequest _fakeHttpRequest;
    private final Map<String, VcService> _vcServices = new HashMap<String, VcService>();

    public UserState(LinkedVcGroupRegistry linkedVcGroupRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{linkedVcGroupRegistry});
        this._linkedVcGroupRegistry = linkedVcGroupRegistry;
    }

    public void init() {
        LinkedVcGroup[] linkedVcGroupArray;
        this._clientId = WebUtils.getCurrentClientId();
        this._fakeHttpRequest = Session.createFakeHttpRequest((String)this._clientId);
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
        try {
            SessionUtil.getHashedSessionId((HttpSession)this._fakeHttpRequest.getSession());
        }
        finally {
            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
        }
        this._hashedClientId = SessionUtil.getHashedClientId((String)this._clientId);
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (linkedVcGroup == null) continue;
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (vcService == null) continue;
                this._vcServices.put(vcService.getServiceGuid(), vcService);
            }
        }
    }

    public Set<VcService> getVcServices() {
        HashSet<VcService> hashSet = new HashSet<VcService>();
        hashSet.addAll(this._vcServices.values());
        return hashSet;
    }

    public VcService getVcServiceByGuid(String string) {
        return this._vcServices.get(string);
    }

    public HttpServletRequest getRequest() {
        return this._fakeHttpRequest;
    }

    public String getHashedClientId() {
        return this._hashedClientId;
    }

    public boolean isClientIdValid() {
        return SessionUtil.isValidClientId((String)this._clientId);
    }
}

