/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.cdc;

import com.vmware.cdc.client.vcenter.AsyncCallback;
import com.vmware.cdc.client.vcenter.AsyncVmomiChangeLogCollector;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.vcenter.listener.vmomi.VmomiServiceStubFactory;
import com.vmware.vim.binding.vim.cdc.AlarmChange;
import com.vmware.vim.binding.vim.cdc.ChangeSet;
import com.vmware.vim.binding.vim.cdc.InventoryChange;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.LiveRefreshFeatureSwitch;
import com.vmware.vise.vim.messaging.UserState;
import com.vmware.vise.vim.messaging.cdc.AlarmUpdate;
import com.vmware.vise.vim.messaging.cdc.ChangeLogUpdate;
import com.vmware.vise.vim.messaging.cdc.ResourceUpdate;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeLogService {
    private static final Log _logger = LogFactory.getLog(ChangeLogService.class);
    private static final long MINIMUN_POLL_WAIT_TIME_IN_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static volatile long _numberOfSlowProcessTasks = 0L;
    private final AtomicBoolean _initialized = new AtomicBoolean(false);
    private final CdcProcessor<?> _navTreeProcessor;
    private final CdcProcessor<?> _objDetailsProcessor;
    private final List<AlarmChangeProcessor<?>> _alarmProcessors;
    private final UserState _userState;
    private final ThreadPoolExecutor _liveRefreshWorker;
    private final ScheduledExecutorService _scheduler;
    private final long _pollPeriodInMillis;
    private final MessageSender _messageSender;
    private final LiveRefreshFeatureSwitch _featureSwitch;
    private final AtomicBoolean _cancelled = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, VcState> _statesByGuid = new ConcurrentHashMap();

    public ChangeLogService(CdcProcessor<?> cdcProcessor, CdcProcessor<?> cdcProcessor2, List<AlarmChangeProcessor<?>> list, UserState userState, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, long l, MessageSender messageSender, LiveRefreshFeatureSwitch liveRefreshFeatureSwitch) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{cdcProcessor, cdcProcessor2, list, userState, threadPoolExecutor, scheduledExecutorService, messageSender, liveRefreshFeatureSwitch});
        this._navTreeProcessor = cdcProcessor;
        this._objDetailsProcessor = cdcProcessor2;
        this._alarmProcessors = list;
        this._userState = userState;
        this._liveRefreshWorker = threadPoolExecutor;
        this._scheduler = scheduledExecutorService;
        this._pollPeriodInMillis = l;
        this._messageSender = messageSender;
        this._featureSwitch = liveRefreshFeatureSwitch;
    }

    public void subscribe(String string, AtomicInteger atomicInteger, Runnable runnable) {
        this._cancelled.set(false);
        if (this._initialized.compareAndSet(false, true)) {
            for (final VcService vcService : this._userState.getVcServices()) {
                final String string2 = vcService.getServiceGuid();
                AsyncVmomiChangeLogCollector asyncVmomiChangeLogCollector = new AsyncVmomiChangeLogCollector(new VmomiServiceStubFactory(){

                    public String getName() {
                        return string2;
                    }

                    public <T extends ManagedObject> T createServiceStub(Class<T> clazz, ManagedObjectReference managedObjectReference) {
                        return (T)vcService.getManagedObject(managedObjectReference);
                    }
                });
                VcState vcState = new VcState(string2, asyncVmomiChangeLogCollector, vcService);
                this._statesByGuid.put(string2, vcState);
                atomicInteger.incrementAndGet();
                asyncVmomiChangeLogCollector.subscribe(AsyncVmomiChangeLogCollector.ChangeLog.ALARM_STATUS, (AsyncCallback)new SubscribeCallback(vcState, atomicInteger, runnable));
            }
        }
    }

    public void openInventory(String string) {
        VcState vcState = this._statesByGuid.get(string);
        if (vcState == null) {
            return;
        }
        if (vcState.subscribedForInventory.compareAndSet(false, true)) {
            vcState.collector.subscribe(AsyncVmomiChangeLogCollector.ChangeLog.INVENTORY, (AsyncCallback)new SubscribeCallback(vcState, null, null));
        }
    }

    public void closeInventory(String string) {
        VcState vcState = this._statesByGuid.get(string);
        if (vcState == null) {
            return;
        }
        if (vcState.subscribedForInventory.compareAndSet(true, false)) {
            vcState.collector.unsubscribe(AsyncVmomiChangeLogCollector.ChangeLog.INVENTORY, (AsyncCallback)new SubscribeCallback(vcState, null, null));
        }
    }

    public void unsubscribe() {
        this._cancelled.set(true);
        this._initialized.compareAndSet(true, false);
    }

    class SubscribeCallback
    implements AsyncCallback<Void> {
        VcState _state;
        AtomicInteger _pendingCalls;
        Runnable _absoluteValuesCallback;

        public SubscribeCallback(VcState vcState, AtomicInteger atomicInteger, Runnable runnable) {
            this._state = vcState;
            this._pendingCalls = atomicInteger;
            this._absoluteValuesCallback = runnable;
        }

        public void onResult(Void void_) {
            if (this._pendingCalls != null && this._pendingCalls.decrementAndGet() == 0) {
                if (ChangeLogService.this._cancelled.get()) {
                    return;
                }
                ChangeLogService.this._liveRefreshWorker.execute(this._absoluteValuesCallback);
            }
            if (!this._state.collector.waitForChanges((AsyncCallback)this._state.waitForChangesCallback)) {
                _logger.info((Object)"SubscribeCallback(onResult):waitForChanges returned false.");
            }
        }

        public void onException(Exception exception) {
            _logger.error((Object)"Subscribe callback .onException():", (Throwable)exception);
            if (this._pendingCalls != null && this._pendingCalls.decrementAndGet() == 0) {
                if (ChangeLogService.this._cancelled.get()) {
                    return;
                }
                ChangeLogService.this._liveRefreshWorker.execute(this._absoluteValuesCallback);
            }
        }

        public void onCancelled() {
            _logger.error((Object)"onCancelled() is not supported.");
        }
    }

    class WaitForChangesCallback
    implements AsyncCallback<ChangeSet> {
        final VcState _state;

        public WaitForChangesCallback(VcState vcState) {
            this._state = vcState;
        }

        public void onResult(ChangeSet changeSet) {
            if (ChangeLogService.this._cancelled.get()) {
                return;
            }
            ChangeLogService.this._liveRefreshWorker.submit(new ProcessTask(changeSet, this._state));
        }

        public void onException(Exception exception) {
            if (ChangeLogService.this._cancelled.get()) {
                _logger.debug((Object)"Error waiting for changes:", (Throwable)exception);
                return;
            }
            _logger.error((Object)"Error waiting for changes:", (Throwable)exception);
            if (exception instanceof SequenceExpiredException) {
                this._state.collector = new AsyncVmomiChangeLogCollector(new VmomiServiceStubFactory(){

                    public String getName() {
                        return WaitForChangesCallback.this._state.vc.getServiceGuid();
                    }

                    public <T extends ManagedObject> T createServiceStub(Class<T> clazz, ManagedObjectReference managedObjectReference) {
                        return (T)WaitForChangesCallback.this._state.vc.getManagedObject(managedObjectReference);
                    }
                });
                if (this._state.subscribedForInventory.get()) {
                    this._state.collector.subscribe(new AsyncVmomiChangeLogCollector.ChangeLog[]{AsyncVmomiChangeLogCollector.ChangeLog.ALARM_STATUS, AsyncVmomiChangeLogCollector.ChangeLog.INVENTORY}, (AsyncCallback)new SubscribeCallback(this._state, null, null));
                } else {
                    this._state.collector.subscribe(AsyncVmomiChangeLogCollector.ChangeLog.ALARM_STATUS, (AsyncCallback)new SubscribeCallback(this._state, null, null));
                }
                return;
            }
            this._state.pollTask.run();
        }

        public void onCancelled() {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"waitForChanges:onCancelled.");
            }
        }
    }

    class ProcessTask
    implements Runnable {
        final VcState _state;
        ChangeSet _changeSet;

        ProcessTask(ChangeSet changeSet, VcState vcState) {
            this._state = vcState;
            this._changeSet = changeSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ChangeLogService.this._cancelled.get() || !ChangeLogService.this._userState.isClientIdValid()) {
                return;
            }
            SessionUtil.setHttpRequest((HttpServletRequest)ChangeLogService.this._userState.getRequest());
            long l = System.nanoTime();
            try {
                long l2;
                ChangeLogUpdate changeLogUpdate;
                if (!ArrayUtil.isNullOrEmpty((Object[])this._changeSet.alarmChanges)) {
                    changeLogUpdate = new AlarmUpdate(this._changeSet.alarmChanges);
                    this.processAlarmChanges((AlarmUpdate)changeLogUpdate);
                }
                if (!ArrayUtil.isNullOrEmpty((Object[])this._changeSet.inventoryChanges)) {
                    changeLogUpdate = new ResourceUpdate(Arrays.asList(this._changeSet.inventoryChanges));
                    if (ChangeLogService.this._featureSwitch.resourceChangesEnabled()) {
                        this.processTreeUpdates((ResourceUpdate)changeLogUpdate);
                    }
                    this.processObjectDetailsUpdates((ResourceUpdate)changeLogUpdate);
                }
                if ((l2 = System.nanoTime() - l) > MINIMUN_POLL_WAIT_TIME_IN_NANOS) {
                    if (_numberOfSlowProcessTasks++ % 200L == 0L) {
                        _logger.info((Object)("Total process plus send time in nanoseconds:" + l2));
                    }
                    this._state.pollTask.pollWaitInNanos = l2;
                } else {
                    _numberOfSlowProcessTasks = 0L;
                    this._state.pollTask.pollWaitInNanos = MINIMUN_POLL_WAIT_TIME_IN_NANOS;
                }
                this._state.pollTask.run();
            }
            catch (Exception exception) {
                _logger.error((Object)("[LiveRefresh] error: " + exception.getMessage()), (Throwable)exception);
            }
            finally {
                SessionUtil.setHttpRequest(null);
            }
        }

        private void processAlarmChanges(AlarmUpdate alarmUpdate) {
            List<AlarmChange> list = Arrays.asList(this._changeSet.alarmChanges);
            for (AlarmChangeProcessor alarmChangeProcessor : ChangeLogService.this._alarmProcessors) {
                PartialUpdate partialUpdate = alarmChangeProcessor.process(list, alarmUpdate.id);
                if (partialUpdate == null) continue;
                if (StringUtil.isNullOrEmpty((String)partialUpdate.getDestination())) {
                    partialUpdate.setDestination("/topic/alarms");
                }
                if (_logger.isDebugEnabled()) {
                    partialUpdate.changeId = alarmUpdate.id;
                    partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                    partialUpdate.timeWhenChangeIsReceived = alarmUpdate.createdOn;
                }
                if (partialUpdate.isEmpty()) continue;
                ChangeLogService.this._messageSender.send((Object)partialUpdate);
            }
        }

        private void processTreeUpdates(ResourceUpdate resourceUpdate) {
            List<InventoryChange> list = resourceUpdate.changes;
            PartialUpdate partialUpdate = ChangeLogService.this._navTreeProcessor.process(list);
            partialUpdate.setDestination("/topic/navTree");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
            }
            if (partialUpdate.isEmpty()) {
                return;
            }
            ChangeLogService.this._messageSender.send((Object)partialUpdate);
        }

        private void processObjectDetailsUpdates(ResourceUpdate resourceUpdate) {
            List<InventoryChange> list = resourceUpdate.changes;
            PartialUpdate partialUpdate = ChangeLogService.this._objDetailsProcessor.process(list);
            partialUpdate.setDestination("/topic/object-details");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
            }
            if (partialUpdate.isEmpty()) {
                return;
            }
            ChangeLogService.this._messageSender.send((Object)partialUpdate);
        }
    }

    class PollTask
    implements Runnable {
        final VcState _state;
        long pollWaitInNanos;

        public PollTask(VcState vcState, long l) {
            this._state = vcState;
            this.pollWaitInNanos = l;
        }

        @Override
        public void run() {
            if (ChangeLogService.this._cancelled.get()) {
                return;
            }
            ChangeLogService.this._scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (ChangeLogService.this._cancelled.get()) {
                        return;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)ChangeLogService.this._userState.getRequest());
                    try {
                        if (!PollTask.this._state.collector.waitForChanges((AsyncCallback)PollTask.this._state.waitForChangesCallback)) {
                            _logger.info((Object)"waitForChanges returned false.");
                        }
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                }
            }, this.pollWaitInNanos, TimeUnit.NANOSECONDS);
        }
    }

    class VcState {
        final PollTask pollTask;
        final WaitForChangesCallback waitForChangesCallback;
        AsyncVmomiChangeLogCollector collector;
        final AtomicBoolean subscribedForInventory = new AtomicBoolean(false);
        final VcService vc;
        final String guid;

        VcState(String string, AsyncVmomiChangeLogCollector asyncVmomiChangeLogCollector, VcService vcService) {
            this.guid = string;
            this.vc = vcService;
            this.collector = asyncVmomiChangeLogCollector;
            this.pollTask = new PollTask(this, TimeUnit.MILLISECONDS.toNanos(ChangeLogService.this._pollPeriodInMillis));
            this.waitForChangesCallback = new WaitForChangesCallback(this);
        }
    }
}

