/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.pollers;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.pollers.PollTask;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Poller
implements Runnable {
    private static final Log _logger = LogFactory.getLog(Poller.class);
    private static final long HUNDRED_SECONDS_IN_NANOS = TimeUnit.SECONDS.toNanos(100L);
    private static final long TEN_SECONDS_IN_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final PollTask _inputPollTask;
    private final ThreadPoolExecutor _liveUpdatesThreadPoolExecutor;
    private final ScheduledExecutorService _pollingThreadPool;
    private final long _delay;
    private final TimeUnit _timeUnitForDelay;
    private final HttpServletRequest _request;
    private final AtomicBoolean _stopped = new AtomicBoolean(false);
    private volatile MessageSender _handler;
    private volatile PeriodicTask _modifiedPeriodicTask;
    private volatile ScheduledFuture<?> _future;
    private int _consequentReschedules = 0;

    public Poller(PollTask pollTask, HttpServletRequest httpServletRequest, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{pollTask, httpServletRequest, threadPoolExecutor, scheduledExecutorService, timeUnit});
        this._inputPollTask = pollTask;
        this._request = httpServletRequest;
        this._liveUpdatesThreadPoolExecutor = threadPoolExecutor;
        this._pollingThreadPool = scheduledExecutorService;
        this._delay = l;
        this._timeUnitForDelay = timeUnit;
    }

    public void setHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._handler = messageSender;
    }

    public void start() {
        this._modifiedPeriodicTask = new PeriodicTask();
        this.schedule();
    }

    @Override
    public synchronized void run() {
        if (this._stopped.get()) {
            return;
        }
        if (this._modifiedPeriodicTask == null) {
            return;
        }
        BlockingQueue<Runnable> blockingQueue = this._liveUpdatesThreadPoolExecutor.getQueue();
        if (blockingQueue.remainingCapacity() == 0) {
            ++this._consequentReschedules;
            if (this._consequentReschedules >= 30) {
                _logger.error((Object)"\"liveUpdatesExecutorThreadPool\" queue was full for more than 300 seconds. The task won't be rescheduled.");
                return;
            }
            _logger.warn((Object)"\"liveUpdatesExecutorThreadPool\" queue is full. Reschedule the task with 10 seconds delay.");
            this._future = this._pollingThreadPool.schedule(this, 10L, TimeUnit.SECONDS);
            return;
        }
        this._consequentReschedules = 0;
        this._modifiedPeriodicTask.executionSubmitTime = System.nanoTime();
        try {
            this._liveUpdatesThreadPoolExecutor.execute(this._modifiedPeriodicTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _logger.error((Object)"Task was rejected for execution:", (Throwable)rejectedExecutionException);
        }
    }

    private void schedule() {
        if (this._stopped.get()) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this._future = this._pollingThreadPool.schedule(this, this._delay, this._timeUnitForDelay);
    }

    public void stop() {
        this._stopped.set(true);
        if (this._future != null) {
            this._future.cancel(true);
        }
        this._modifiedPeriodicTask = null;
        this._handler = null;
    }

    static /* synthetic */ AtomicBoolean access$200(Poller poller) {
        return poller._stopped;
    }

    static /* synthetic */ MessageSender access$300(Poller poller) {
        return poller._handler;
    }

    static /* synthetic */ void access$400(Poller poller) {
        poller.schedule();
    }

    static /* synthetic */ HttpServletRequest access$500(Poller poller) {
        return poller._request;
    }

    static /* synthetic */ long access$600() {
        return HUNDRED_SECONDS_IN_NANOS;
    }

    static /* synthetic */ ThreadPoolExecutor access$700(Poller poller) {
        return poller._liveUpdatesThreadPoolExecutor;
    }

    static /* synthetic */ Log access$800() {
        return _logger;
    }

    static /* synthetic */ long access$900() {
        return TEN_SECONDS_IN_NANOS;
    }

    static /* synthetic */ PollTask access$1000(Poller poller) {
        return poller._inputPollTask;
    }

    private class PeriodicTask
    implements Runnable {
        private long executionSubmitTime;
        private long executionStartTime;
        private long executionDoneTime;

        private PeriodicTask() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

