/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.pollers;

import com.google.common.base.Optional;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidCollectorVersion;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.Update;
import com.vmware.vise.vim.messaging.UpdatesProvider;
import com.vmware.vise.vim.messaging.pollers.CancelException;
import com.vmware.vise.vim.messaging.pollers.PollTask;
import com.vmware.vise.vim.messaging.pollers.Poller;
import com.vmware.vise.vim.messaging.propcollector.FilterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertyCollectorPollerFactory {
    private static final AtomicLong PROPERTY_COLLECTOR_CHANGE_ID_COUNTER = new AtomicLong();
    private static final String PROPERT_COLLECTOR_CHANGE_PREFIX = "PropertyCollectorChange:";
    private static final Log _logger = LogFactory.getLog(PropertyCollectorPollerFactory.class);
    private final List<UpdatesProcessor<?>> _updatesProcessors;
    private final ThreadPoolExecutor _liveUpdatesThreadPoolExecutor;
    private final ScheduledExecutorService _pollingThreadPool;
    private final long _pollPeriodInMilliseconds;

    public PropertyCollectorPollerFactory(List<UpdatesProcessor<?>> list, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, long l) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, threadPoolExecutor, scheduledExecutorService});
        this._updatesProcessors = list;
        this._liveUpdatesThreadPoolExecutor = threadPoolExecutor;
        this._pollingThreadPool = scheduledExecutorService;
        this._pollPeriodInMilliseconds = l;
    }

    public Poller createPoller(final String string, HttpServletRequest httpServletRequest, VcService vcService, final FilterRegistry filterRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, httpServletRequest, vcService, filterRegistry});
        PropertyCollector propertyCollector = (PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().propertyCollector);
        final UpdatesProvider updatesProvider = new UpdatesProvider(propertyCollector);
        PollTask pollTask = new PollTask(){

            @Override
            public List<PartialUpdate<?>> call() throws CancelException {
                ArrayList arrayList = new ArrayList();
                PropertyCollectorPollerFactory.this.logCheckForUpdates(updatesProvider.getPCguid(), string);
                try {
                    Optional<Update> optional = updatesProvider.checkForUpdates();
                    if (!optional.isPresent()) {
                        return arrayList;
                    }
                    for (PropertyCollector.FilterUpdate filterUpdate : ((Update)optional.get()).getUpdateSet().getFilterSet()) {
                        ManagedObjectReference managedObjectReference = filterUpdate.getFilter();
                        String string2 = filterRegistry.getDestination(managedObjectReference);
                        if (string2 == null) {
                            _logger.error((Object)("[LiveRefresh] Destination not found for filter: " + managedObjectReference));
                            continue;
                        }
                        PartialUpdate partialUpdate = PropertyCollectorPollerFactory.this.transform(string2, filterUpdate);
                        if (partialUpdate == null) continue;
                        PropertyCollectorPollerFactory.this.logTransform(partialUpdate, ((Update)optional.get()).getCreatedOn(), string);
                        arrayList.add(partialUpdate);
                    }
                }
                catch (NotAuthenticated | NotAuthenticatedError throwable) {
                    _logger.error((Object)("[LiveRefresh] Not authenticated: " + throwable.getMessage()), throwable);
                    throw new CancelException("Unauthenticated", (Exception)throwable);
                }
                catch (InvalidCollectorVersion invalidCollectorVersion) {
                    _logger.error((Object)("[LiveRefresh] Invalid collector version: " + invalidCollectorVersion.getMessage()));
                    updatesProvider.reset();
                }
                catch (Exception exception) {
                    _logger.error((Object)("[LiveRefresh] Property collection exception: " + exception.getMessage()));
                }
                return arrayList;
            }
        };
        Poller poller = new Poller(pollTask, httpServletRequest, this._liveUpdatesThreadPoolExecutor, this._pollingThreadPool, this._pollPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        return poller;
    }

    private PartialUpdate<?> transform(String string, PropertyCollector.FilterUpdate filterUpdate) {
        for (UpdatesProcessor<?> updatesProcessor : this._updatesProcessors) {
            PartialUpdate partialUpdate = updatesProcessor.process(string, filterUpdate);
            if (partialUpdate == null) continue;
            partialUpdate.setDestination(string);
            return partialUpdate;
        }
        _logger.warn((Object)String.format("Could not handle update for destination [%s]: %s", string, filterUpdate));
        return null;
    }

    private void logTransform(PartialUpdate<?> partialUpdate, long l, String string) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        partialUpdate.changeId = PROPERT_COLLECTOR_CHANGE_PREFIX + PROPERTY_COLLECTOR_CHANGE_ID_COUNTER.incrementAndGet();
        partialUpdate.timeWhenChangeIsReceived = l;
        partialUpdate.timeWhenUpdateIsPushedToTheStream = l2;
        long l3 = l2 - l;
        long l4 = Thread.currentThread().getId();
        String string2 = String.format("[LiveRefresh] hashedClientId: [%s] Update processed for destination: [%s], processing time: [%d] milliseconds, Thread Id: [%d], ChangeId: [%s], updates: [%d], deletes: [%d]", string, partialUpdate.destination, l3, l4, partialUpdate.changeId, partialUpdate.updates.size(), partialUpdate.deleted.size());
        _logger.debug((Object)string2);
    }

    private void logCheckForUpdates(String string, String string2) {
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("[LiveRefresh] hashedClientId: [" + string2 + "] CheckForUpdates in thread ID: " + Thread.currentThread().getId() + " serverGuid: " + string));
        }
    }
}

