/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.pollers;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.TaskRegistryProcessor;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskRegistryPoller
implements Runnable {
    private static final Log _logger = LogFactory.getLog(TaskRegistryPoller.class);
    private final TaskRegistryProcessor _taskRegistryProcessor;
    private final ThreadPoolExecutor _liveUpdatesThreadPoolExecutor;
    private final ScheduledExecutorService _pollingThreadPool;
    private final long _interval;
    private final TimeUnit _timeUnitForInterval;
    private final Set<MessageSender> _messageSenders = new HashSet<MessageSender>();
    private Runnable _periodicTask;
    private ScheduledFuture<?> _future;
    private boolean _started = false;
    private int consequentReschedulingsWithoutExecution = 0;

    public TaskRegistryPoller(TaskRegistryProcessor taskRegistryProcessor, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{taskRegistryProcessor, threadPoolExecutor, scheduledExecutorService, timeUnit});
        this._taskRegistryProcessor = taskRegistryProcessor;
        this._liveUpdatesThreadPoolExecutor = threadPoolExecutor;
        this._pollingThreadPool = scheduledExecutorService;
        this._interval = l;
        this._timeUnitForInterval = timeUnit;
    }

    public synchronized void addUpdateHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._messageSenders.add(messageSender);
        if (!this._started) {
            this.start();
        }
    }

    public synchronized void removeUpdateHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._messageSenders.remove(messageSender);
        if (this._messageSenders.isEmpty()) {
            this.stop();
        }
    }

    public synchronized void init() {
        this._periodicTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TaskRegistryPoller taskRegistryPoller = TaskRegistryPoller.this;
                synchronized (taskRegistryPoller) {
                    if (!TaskRegistryPoller.this._started) {
                        return;
                    }
                    PartialUpdate partialUpdate = null;
                    try {
                        partialUpdate = TaskRegistryPoller.this._taskRegistryProcessor.process();
                        if (partialUpdate == null || partialUpdate.isEmpty()) {
                            TaskRegistryPoller.this.schedule(false);
                            return;
                        }
                        partialUpdate.destination = "/topic/recent-tasks";
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("[LiveRefresh] ClientTasks error: " + exception.getMessage()), (Throwable)exception);
                        TaskRegistryPoller.this.schedule(false);
                        return;
                    }
                    for (MessageSender messageSender : TaskRegistryPoller.this._messageSenders) {
                        messageSender.send((Object)partialUpdate);
                    }
                    TaskRegistryPoller.this.schedule(false);
                }
            }
        };
    }

    private void start() {
        this.schedule(true);
        this._started = true;
    }

    private void stop() {
        if (this._future != null) {
            this._future.cancel(true);
        }
        this._started = false;
    }

    private void schedule(boolean bl) {
        if (!bl && Thread.interrupted()) {
            this._started = false;
            return;
        }
        this._future = this._pollingThreadPool.schedule(this, this._interval, this._timeUnitForInterval);
    }

    @Override
    public synchronized void run() {
        if (!this._started || this._periodicTask == null) {
            return;
        }
        BlockingQueue<Runnable> blockingQueue = this._liveUpdatesThreadPoolExecutor.getQueue();
        if (blockingQueue.remainingCapacity() == 0) {
            ++this.consequentReschedulingsWithoutExecution;
            if (this.consequentReschedulingsWithoutExecution >= 30) {
                _logger.error((Object)"\"liveUpdatesExecutorThreadPool\" queue was full for more than 900 seconds. The task is scheduled with 1 hour delay.");
                this._future = this._pollingThreadPool.schedule(this, 1L, TimeUnit.HOURS);
                return;
            }
            _logger.warn((Object)"\"liveUpdatesExecutorThreadPool\" queue is full. Reschedule the task with 30 seconds delay.");
            this._future = this._pollingThreadPool.schedule(this, 30L, TimeUnit.SECONDS);
            return;
        }
        this.consequentReschedulingsWithoutExecution = 0;
        try {
            this._liveUpdatesThreadPoolExecutor.execute(this._periodicTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _logger.error((Object)"Task was rejected for execution:", (Throwable)rejectedExecutionException);
        }
    }
}

