/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.propcollector;

import com.vmware.cdc.client.vcenter.AsyncCallback;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.RequestCanceled;
import com.vmware.vim.binding.vmodl.query.InvalidCollectorVersion;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncPropertyCollector {
    private static final Log _logger = LogFactory.getLog(AsyncPropertyCollector.class);
    private static final PropertyCollector.WaitOptions WAIT_OPTIONS = new PropertyCollector.WaitOptions(Integer.valueOf((int)TimeUnit.MINUTES.toSeconds(8L)), null);
    private final PropertyCollector _stub;
    private final AtomicReference<String> _version = new AtomicReference<String>("");
    private final AtomicBoolean _pendingAddFilter = new AtomicBoolean(false);
    private final AtomicReference<Runnable> _scheduledAddFilter = new AtomicReference();

    public AsyncPropertyCollector(PropertyCollector propertyCollector) {
        this._stub = propertyCollector;
    }

    public void createFilter(final PropertyCollector.FilterSpec filterSpec, final AsyncCallback<ManagedObjectReference> asyncCallback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AsyncPropertyCollector.this._stub.createFilter(filterSpec, true, (Future)AsyncPropertyCollector.this.getCreateFilterFuture((AsyncCallback<ManagedObjectReference>)asyncCallback));
            }
        };
        if (!this._scheduledAddFilter.compareAndSet(null, runnable)) {
            throw new IllegalStateException("Cannot schedule more than one subcription modification.");
        }
        if (this._pendingAddFilter.compareAndSet(false, true) && this._scheduledAddFilter.compareAndSet(runnable, null)) {
            runnable.run();
        }
    }

    public boolean waitForChanges(final AsyncCallback<PropertyCollector.UpdateSet> asyncCallback) {
        if (this._pendingAddFilter.get()) {
            return false;
        }
        final String string = this._version.get();
        this._stub.waitForUpdatesEx(string, WAIT_OPTIONS, (Future)new PcFuture<PropertyCollector.UpdateSet>(){

            @Override
            public void set(PropertyCollector.UpdateSet updateSet) {
                if (updateSet == null) {
                    asyncCallback.onResult((Object)updateSet);
                    return;
                }
                String string2 = updateSet.getVersion();
                if (string2 == null) {
                    asyncCallback.onResult((Object)updateSet);
                    return;
                }
                if (!AsyncPropertyCollector.this._version.compareAndSet(string, string2)) {
                    _logger.error((Object)("Cancelling current wait for updates because of version mismatch: oldVersion:" + string + " newVersion:" + string2 + " currentVersion:" + (String)AsyncPropertyCollector.this._version.get()));
                    asyncCallback.onCancelled();
                } else {
                    asyncCallback.onResult((Object)updateSet);
                }
            }

            @Override
            public void setException(Exception exception) {
                if (exception instanceof InvalidCollectorVersion) {
                    _logger.warn((Object)("InvalidCollectorVersion: " + string), (Throwable)exception);
                    asyncCallback.onException(exception);
                } else if (exception instanceof RequestCanceled) {
                    _logger.info((Object)("Request cancelled: " + exception.getMessage() + ". Version: " + string));
                    asyncCallback.onCancelled();
                } else {
                    _logger.warn((Object)("Exception during waitForUpdatesEx() call with version: " + string), (Throwable)exception);
                    asyncCallback.onException(exception);
                }
            }
        });
        return true;
    }

    private PcFuture<ManagedObjectReference> getCreateFilterFuture(final AsyncCallback<ManagedObjectReference> asyncCallback) {
        return new PcFuture<ManagedObjectReference>(){

            @Override
            public void set(ManagedObjectReference managedObjectReference) {
                Runnable runnable = AsyncPropertyCollector.this._scheduledAddFilter.getAndSet(null);
                if (runnable != null) {
                    runnable.run();
                } else {
                    AsyncPropertyCollector.this._pendingAddFilter.set(false);
                }
                asyncCallback.onResult((Object)managedObjectReference);
            }

            @Override
            public void setException(Exception exception) {
                _logger.error((Object)"Error during subcription.", (Throwable)exception);
                AsyncPropertyCollector.this._scheduledAddFilter.set(null);
                AsyncPropertyCollector.this._pendingAddFilter.set(false);
                asyncCallback.onException(exception);
            }
        };
    }

    private static abstract class PcFuture<T>
    implements Future<T> {
        private PcFuture() {
        }

        public boolean cancel(boolean bl) {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public boolean isCancelled() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public boolean isDone() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public T get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public void set() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public abstract void set(T var1);

        public abstract void setException(Exception var1);
    }
}

