/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.propcollector;

import com.vmware.cdc.client.vcenter.AsyncCallback;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.UserState;
import com.vmware.vise.vim.messaging.propcollector.AsyncPropertyCollector;
import com.vmware.vise.vim.messaging.propcollector.FilterRegistry;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyCollectorService {
    private static final Log _logger = LogFactory.getLog(PropertyCollectorService.class);
    private static final long MINIMUN_POLL_WAIT_TIME_IN_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static volatile long _numberOfSlowProcessTasks = 0L;
    private final Deque<VcState> _vcStates = new ConcurrentLinkedDeque<VcState>();
    public final FilterRegistry filterRegistry;
    public final List<UpdatesProcessor<?>> updatesProcessors;
    private final MessageSender _messageSender;
    private final UserState _userState;
    public final ThreadPoolExecutor liveRefreshWorker;
    private final ScheduledExecutorService _scheduler;
    private final long _pollPeriodInMillis;
    private final AtomicBoolean _cancelled = new AtomicBoolean(false);
    private Phaser _createFilterPhaser = new Phaser();

    public PropertyCollectorService(List<UpdatesProcessor<?>> list, MessageSender messageSender, UserState userState, FilterRegistry filterRegistry, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, long l) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, messageSender, userState, filterRegistry, threadPoolExecutor, scheduledExecutorService});
        this.updatesProcessors = list;
        this._messageSender = messageSender;
        this._userState = userState;
        this.liveRefreshWorker = threadPoolExecutor;
        this._scheduler = scheduledExecutorService;
        this._pollPeriodInMillis = l;
        this.filterRegistry = filterRegistry;
    }

    public void init() {
        for (VcService vcService : this._userState.getVcServices()) {
            AsyncPropertyCollector asyncPropertyCollector = new AsyncPropertyCollector((PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().getPropertyCollector()));
            VcState vcState = new VcState(asyncPropertyCollector, vcService);
            this._vcStates.push(vcState);
        }
    }

    public void subscribe(String string, AtomicInteger atomicInteger, Runnable runnable) {
        this._cancelled.set(false);
        for (VcState vcState : this._vcStates) {
            VcService vcService = vcState.vcService;
            String string2 = vcState.guid;
            AsyncPropertyCollector asyncPropertyCollector = vcState.propertyCollector;
            for (UpdatesProcessor<?> updatesProcessor : this.updatesProcessors) {
                PropertyCollector.FilterSpec filterSpec = updatesProcessor.createFilterSpec(string, vcService);
                if (filterSpec == null || !this.filterRegistry.registerFilter(string2, string)) continue;
                atomicInteger.incrementAndGet();
                this._createFilterPhaser.register();
                asyncPropertyCollector.createFilter(filterSpec, new CreateFilterFuture(vcState, string, atomicInteger, runnable));
            }
            vcState.pollTask.run();
        }
    }

    public void unsubscribe() {
        this._cancelled.set(true);
    }

    class WaitForUpdatesCallback
    implements AsyncCallback<PropertyCollector.UpdateSet> {
        final VcState _state;

        WaitForUpdatesCallback(VcState vcState) {
            this._state = vcState;
        }

        public void onResult(PropertyCollector.UpdateSet updateSet) {
            if (!this._state.pendingWaitForUpdates.compareAndSet(true, false)) {
                _logger.error((Object)"Wrong _pendingWaitForUpdates flag value.(onResult wait)");
            }
            if (PropertyCollectorService.this._cancelled.get()) {
                return;
            }
            PropertyCollectorService.this.liveRefreshWorker.submit(new ProcessTask(updateSet, this._state));
        }

        public void onException(Exception exception) {
            _logger.error((Object)"Error waiting for updates:", (Throwable)exception);
            if (!this._state.pendingWaitForUpdates.compareAndSet(true, false)) {
                _logger.error((Object)"Wrong _pendingWaitForUpdates flag value.(onError wait)");
            }
            if (PropertyCollectorService.this._cancelled.get()) {
                return;
            }
            this._state.pollTask.run();
        }

        public void onCancelled() {
            if (!this._state.pendingWaitForUpdates.compareAndSet(true, false)) {
                StringBuilder stringBuilder = new StringBuilder("StackTrace:\n");
                for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                    stringBuilder.append(stackTraceElement.toString()).append('\n');
                }
                _logger.error((Object)("Wrong _pendingWaitForUpdates flag value.(onCancel wait), " + stringBuilder.toString()));
            }
            if (PropertyCollectorService.this._cancelled.get()) {
                return;
            }
            this._state.pollTask.run();
        }
    }

    class ProcessTask
    implements Runnable {
        final VcState _state;
        final PropertyCollector.UpdateSet _updateSet;

        ProcessTask(PropertyCollector.UpdateSet updateSet, VcState vcState) {
            this._updateSet = updateSet;
            this._state = vcState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (PropertyCollectorService.this._cancelled.get() || !PropertyCollectorService.this._userState.isClientIdValid()) {
                return;
            }
            if (this._updateSet == null && !this._state.pendingWaitForUpdates.get()) {
                this._state.pollTask.run();
                return;
            }
            SessionUtil.setHttpRequest((HttpServletRequest)PropertyCollectorService.this._userState.getRequest());
            try {
                long l = System.nanoTime();
                ArrayList arrayList = new ArrayList();
                for (PropertyCollector.FilterUpdate filterUpdate : this._updateSet.getFilterSet()) {
                    PartialUpdate<?> partialUpdate;
                    ManagedObjectReference managedObjectReference = filterUpdate.getFilter();
                    String string = PropertyCollectorService.this.filterRegistry.getDestination(managedObjectReference);
                    if (string == null) {
                        try {
                            PropertyCollectorService.this._createFilterPhaser.awaitAdvanceInterruptibly(0, 1L, TimeUnit.SECONDS);
                            string = PropertyCollectorService.this.filterRegistry.getDestination(managedObjectReference);
                            if (string == null) {
                                _logger.error((Object)("Null destination for filter update:" + filterUpdate + "\nUsing destination \"/topic/recent-tasks\""));
                            }
                        }
                        catch (Exception exception) {
                            _logger.warn((Object)"Filter wasn't populated in 1 second. Using default destination: \"/topic/recent-tasks\"", (Throwable)exception);
                        }
                        string = "/topic/recent-tasks";
                    }
                    if ((partialUpdate = this.transform(string, filterUpdate)) == null) continue;
                    arrayList.add(partialUpdate);
                }
                for (PartialUpdate partialUpdate : arrayList) {
                    PropertyCollectorService.this._messageSender.send((Object)partialUpdate);
                }
                long l2 = System.nanoTime() - l;
                if (l2 > MINIMUN_POLL_WAIT_TIME_IN_NANOS) {
                    if (_numberOfSlowProcessTasks++ % 200L == 0L) {
                        _logger.info((Object)("Total process plus send time in nanoseconds:" + l2));
                    }
                    this._state.pollTask.pollWaitInNanos = l2;
                } else {
                    _numberOfSlowProcessTasks = 0L;
                    this._state.pollTask.pollWaitInNanos = MINIMUN_POLL_WAIT_TIME_IN_NANOS;
                }
                if (!this._state.pendingWaitForUpdates.get()) {
                    this._state.pollTask.run();
                }
            }
            finally {
                SessionUtil.setHttpRequest(null);
            }
        }

        private PartialUpdate<?> transform(String string, PropertyCollector.FilterUpdate filterUpdate) {
            for (UpdatesProcessor<?> updatesProcessor : PropertyCollectorService.this.updatesProcessors) {
                PartialUpdate partialUpdate = updatesProcessor.process(string, filterUpdate);
                if (partialUpdate == null) continue;
                partialUpdate.setDestination(string);
                return partialUpdate;
            }
            _logger.warn((Object)String.format("Could not handle update for destination [%s]: %s", string, filterUpdate));
            return null;
        }
    }

    class PollTask
    implements Runnable {
        final VcState _state;
        long pollWaitInNanos;

        PollTask(VcState vcState, long l) {
            this._state = vcState;
            this.pollWaitInNanos = l;
        }

        @Override
        public void run() {
            if (PropertyCollectorService.this._cancelled.get() || this._state.pendingWaitForUpdates.get()) {
                return;
            }
            PropertyCollectorService.this._scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (PropertyCollectorService.this._cancelled.get()) {
                        return;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)PropertyCollectorService.this._userState.getRequest());
                    try {
                        if (PollTask.this._state.pendingWaitForUpdates.compareAndSet(false, true)) {
                            PollTask.this._state.propertyCollector.waitForChanges(PollTask.this._state.waitForUpdatesCallback);
                        }
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                }
            }, this.pollWaitInNanos, TimeUnit.NANOSECONDS);
        }
    }

    class CreateFilterFuture
    implements AsyncCallback<ManagedObjectReference> {
        VcState _state;
        AtomicInteger _pendingCalls;
        Runnable _absoluteValuesCallback;
        String _destination;

        CreateFilterFuture(VcState vcState, String string, AtomicInteger atomicInteger, Runnable runnable) {
            this._state = vcState;
            this._pendingCalls = atomicInteger;
            this._absoluteValuesCallback = runnable;
            this._destination = string;
        }

        public void onResult(ManagedObjectReference managedObjectReference) {
            PropertyCollectorService.this.filterRegistry.add(managedObjectReference, this._destination);
            PropertyCollectorService.this._createFilterPhaser.arrive();
            if (this._pendingCalls.decrementAndGet() == 0) {
                if (PropertyCollectorService.this._cancelled.get()) {
                    return;
                }
                PropertyCollectorService.this.liveRefreshWorker.execute(this._absoluteValuesCallback);
            }
        }

        public void onException(Exception exception) {
            _logger.error((Object)"CreateFilterFuture.onException():", (Throwable)exception);
            if (this._pendingCalls.decrementAndGet() == 0) {
                if (PropertyCollectorService.this._cancelled.get()) {
                    return;
                }
                PropertyCollectorService.this.liveRefreshWorker.execute(this._absoluteValuesCallback);
            }
        }

        public void onCancelled() {
            _logger.error((Object)"onCancelled() is not supported.");
        }
    }

    class VcState {
        VcService vcService;
        PollTask pollTask;
        WaitForUpdatesCallback waitForUpdatesCallback;
        AsyncPropertyCollector propertyCollector;
        AtomicBoolean pendingWaitForUpdates = new AtomicBoolean(false);
        String guid;

        VcState(AsyncPropertyCollector asyncPropertyCollector, VcService vcService) {
            this.propertyCollector = asyncPropertyCollector;
            this.vcService = vcService;
            this.guid = vcService.getServiceGuid();
            this.pollTask = new PollTask(this, TimeUnit.MILLISECONDS.toNanos(PropertyCollectorService.this._pollPeriodInMillis));
            this.waitForUpdatesCallback = new WaitForUpdatesCallback(this);
        }
    }
}

