/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.update.VcOperations;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.websocket.MessagingService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentLibraryOperations
implements VcOperations {
    private static final Log _logger = LogFactory.getLog(ContentLibraryOperations.class);
    private final String UNKNOWN_MODEL = "__CL_UNKNOWN_MODEL__";
    private final String LIBRARY_MODEL = "com.vmware.content.LibraryModel";
    private final String ITEM_MODEL = "com.vmware.content.library.ItemModel";
    private final Map<String, String> ADD_TASKS = ImmutableMap.of((Object)"com.vmware.ovfs.LibraryItem.instantiate", (Object)"__CL_UNKNOWN_MODEL__", (Object)"com.vmware.ovfs.LibraryItem.capture", (Object)"com.vmware.content.library.ItemModel", (Object)"com.vmware.content.LibraryItem.Copy", (Object)"com.vmware.content.library.ItemModel", (Object)"com.vmware.content.Library.Create", (Object)"com.vmware.content.LibraryModel");
    private final Map<String, String> resourceTypeByTaskId = ImmutableMap.of((Object)"com.vmware.ovfs.LibraryItem.instantiate", (Object)"__UNKNOWN", (Object)"com.vmware.ovfs.LibraryItem.capture", (Object)"com.vmware.content.library.Item", (Object)"com.vmware.content.LibraryItem.Copy", (Object)"com.vmware.content.library.Item", (Object)"com.vmware.content.Library.Create", (Object)"com.vmware.content.Library");
    private final List<String> CHANGE_TASKS = Arrays.asList("com.vmware.content.LibraryItem.Update", "com.vmware.content.LibraryItem.UploadContent", "com.vmware.content.Library.Update");
    private final Map<String, String> DELETE_TASKS = ImmutableMap.of((Object)"com.vmware.content.LibraryItem.Delete", (Object)"com.vmware.content.library.ItemModel", (Object)"com.vmware.content.Library.Delete", (Object)"com.vmware.content.LibraryModel");
    private final List<String> RELATIONSHIP_CHANGE_TASKS = Collections.singletonList("com.vmware.content.Library.Sync");
    private static final int RETRIES = 3;
    private final ObjectReferenceService _objRefService;
    private final ListeningExecutorService _listeningExecutor;
    private final MessagingService _messagingService;
    private final QueryServiceFactory _queryServiceFactory;

    public ContentLibraryOperations(ObjectReferenceService objectReferenceService, MessagingService messagingService, QueryServiceFactory queryServiceFactory, ListeningExecutorService listeningExecutorService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, listeningExecutorService, messagingService, queryServiceFactory});
        this._objRefService = objectReferenceService;
        this._listeningExecutor = listeningExecutorService;
        this._messagingService = messagingService;
        this._queryServiceFactory = queryServiceFactory;
    }

    @Override
    public Optional<ListenableFuture<ObjectChangeInfo>> handleOperationResult(HttpSession httpSession, OperationResultEx operationResultEx) {
        if (operationResultEx == null || operationResultEx.taskInfo == null || operationResultEx.taskInfo.taskTypeId == null || httpSession == null) {
            return Optional.absent();
        }
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo.state != TaskState.SUCCESS) {
            return Optional.absent();
        }
        Object object = this.extractEntity(operationResultEx, clientTaskInfo);
        if (object == null) {
            return Optional.absent();
        }
        if (this.containsTaskId(this.RELATIONSHIP_CHANGE_TASKS, clientTaskInfo.taskTypeId) != null) {
            return this.createImmediateResult(object, OperationType.RELATIONSHIP_CHANGE);
        }
        if (this.ADD_TASKS.containsKey(clientTaskInfo.taskTypeId)) {
            String string = this.ADD_TASKS.get(clientTaskInfo.taskTypeId);
            if ("__CL_UNKNOWN_MODEL__".equals(string)) {
                _logger.error((Object)("Unknown model for clientTaskInfo: " + clientTaskInfo));
                return Optional.absent();
            }
            return this.createAsyncResult(httpSession, object, string, OperationType.ADD);
        }
        if (this.containsTaskId(this.CHANGE_TASKS, clientTaskInfo.taskTypeId) != null) {
            return this.createImmediateResult(object, OperationType.CHANGE);
        }
        String string = this.DELETE_TASKS.get(clientTaskInfo.taskTypeId);
        if (string != null) {
            return this.createAsyncResult(httpSession, object, string, OperationType.DELETE);
        }
        return Optional.absent();
    }

    private Optional<ListenableFuture<ObjectChangeInfo>> createAsyncResult(HttpSession httpSession, Object object, String string, OperationType operationType) {
        ListenableFuture listenableFuture = this._listeningExecutor.submit(this.searchForEntity(httpSession, object, string, operationType));
        Futures.addCallback((ListenableFuture)listenableFuture, this.createFutureCallback(httpSession));
        return Optional.of((Object)listenableFuture);
    }

    private ObjectChangeInfo createObjectChangeInfo(Object object, OperationType operationType) {
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.object = object;
        objectChangeInfo.objectId = this._objRefService.getUid(object, true);
        objectChangeInfo.operationType = operationType;
        return objectChangeInfo;
    }

    private Optional<ListenableFuture<ObjectChangeInfo>> createImmediateResult(Object object, OperationType operationType) {
        ObjectChangeInfo objectChangeInfo = this.createObjectChangeInfo(object, operationType);
        this._messagingService.sendMessage(objectChangeInfo);
        return Optional.of((Object)Futures.immediateFuture((Object)objectChangeInfo));
    }

    private Object extractEntity(OperationResultEx operationResultEx, ClientTaskInfo clientTaskInfo) {
        if (this.ADD_TASKS.containsKey(clientTaskInfo.taskTypeId)) {
            String string = this.resourceTypeByTaskId.get(clientTaskInfo.taskTypeId);
            if ("__UNKNOWN".equals(string)) {
                return null;
            }
            if (clientTaskInfo.result instanceof String) {
                return VapiUriSchemeUtil.createUri((String)string, (String)((String)clientTaskInfo.result));
            }
            return clientTaskInfo.result;
        }
        if (operationResultEx.operationResult.entity != null) {
            return operationResultEx.operationResult.entity;
        }
        return null;
    }

    private String containsTaskId(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.contains(string)) continue;
            return string2;
        }
        return null;
    }

    private FutureCallback<ObjectChangeInfo> createFutureCallback(final HttpSession httpSession) {
        return new FutureCallback<ObjectChangeInfo>(){

            public void onSuccess(@Nullable ObjectChangeInfo objectChangeInfo) {
                if (objectChangeInfo == null) {
                    return;
                }
                try {
                    SessionUtil.setHttpSession((HttpSession)httpSession);
                    ContentLibraryOperations.this._messagingService.sendMessage(objectChangeInfo);
                }
                finally {
                    SessionUtil.setHttpSession(null);
                }
            }

            public void onFailure(Throwable throwable) {
                _logger.error((Object)"Future callback failed: ", throwable);
            }
        };
    }

    private Callable<ObjectChangeInfo> searchForEntity(final HttpSession httpSession, final Object object, final String string, final OperationType operationType) {
        return new Callable<ObjectChangeInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectChangeInfo call() throws Exception {
                int n = 3;
                while (n > 0) {
                    try {
                        SessionUtil.setHttpSession((HttpSession)httpSession);
                        ResultSet resultSet = ContentLibraryOperations.this._queryServiceFactory.getQueryService().select(new String[]{"@modelKey"}).from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).withTotalCount().fetch();
                        if (operationType == OperationType.ADD && resultSet.getTotalCount() > 0) {
                            ObjectChangeInfo objectChangeInfo = ContentLibraryOperations.this.createObjectChangeInfo(object, OperationType.ADD);
                            return objectChangeInfo;
                        }
                        if (operationType == OperationType.DELETE && resultSet.getTotalCount() == 0) {
                            ObjectChangeInfo objectChangeInfo = ContentLibraryOperations.this.createObjectChangeInfo(object, OperationType.DELETE);
                            return objectChangeInfo;
                        }
                        --n;
                        Thread.sleep(1000L);
                    }
                    finally {
                        SessionUtil.setHttpSession(null);
                    }
                }
                _logger.error((Object)("Failed to verify that entity exists for: " + object + " with model: " + string + ", opType: " + operationType));
                return null;
            }
        };
    }

    private static class ResourceTypes {
        public static final String LIBRARY = "com.vmware.content.Library";
        public static final String LIBRARY_ITEM = "com.vmware.content.library.Item";
        public static final String UNKNOWN = "__UNKNOWN";

        private ResourceTypes() {
        }
    }
}

