/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.update.impl.CornerCaseOperationHandler;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.update.impl.UpdatesUtil;

public class PostProcessor {
    private final CornerCaseOperationHandler _cornerCaseHandler;
    private final ObjectReferenceService _objRefService;

    public PostProcessor(CornerCaseOperationHandler cornerCaseOperationHandler, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{cornerCaseOperationHandler, objectReferenceService});
        this._cornerCaseHandler = cornerCaseOperationHandler;
        this._objRefService = objectReferenceService;
    }

    public ObjectChangeInfo process(OperationResultEx operationResultEx) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{operationResultEx});
        if (operationResultEx.taskInfo != null) {
            return this.processAsyncOperationUpdates(operationResultEx);
        }
        return this.processSyncOperationUpdates(operationResultEx);
    }

    private ObjectChangeInfo processAsyncOperationUpdates(OperationResultEx operationResultEx) {
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo.state != TaskState.SUCCESS) {
            return null;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            String string = this.getResultEntityUidFromTaskInfo(clientTaskInfo);
            objectChangeInfo.objectId = UpdatesUtil.is60VcOperation(operationResultEx) ? (String)this._cornerCaseHandler.handleOperation(operationResultEx).or((Object)string) : string;
            objectChangeInfo.object = clientTaskInfo.result;
        } else if (operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) {
            objectChangeInfo.objectId = this.getEntityUidFromTaskInfo(clientTaskInfo);
            objectChangeInfo.object = clientTaskInfo.entity;
        }
        return objectChangeInfo;
    }

    private String getResultEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.resultEntityUid)) {
            if (clientTaskInfo.result != null) {
                string = this._objRefService.getUid(clientTaskInfo.result, true);
            }
        } else {
            string = clientTaskInfo.resultEntityUid;
        }
        return string;
    }

    private String getEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.entityUid)) {
            if (clientTaskInfo.entity != null) {
                string = this._objRefService.getUid(clientTaskInfo.entity, true);
            }
        } else {
            string = clientTaskInfo.entityUid;
        }
        return string;
    }

    private ObjectChangeInfo processSyncOperationUpdates(OperationResultEx operationResultEx) {
        Object object;
        if (operationResultEx.operationResult.error != null) {
            return null;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            Object object2 = null;
            String string = null;
            if (operationResultEx.operationResult.result != null) {
                object2 = operationResultEx.operationResult.result;
                string = this._objRefService.getUid(object2, true);
            }
            if (string == null && operationResultEx.operationResult.entity != null) {
                object2 = operationResultEx.operationResult.entity;
                string = this._objRefService.getUid(object2, true);
            }
            objectChangeInfo.objectId = string;
            objectChangeInfo.object = object2;
        } else if ((operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) && (object = operationResultEx.operationResult.entity) != null) {
            objectChangeInfo.objectId = this._objRefService.getUid(object, true);
            objectChangeInfo.object = object;
        }
        return objectChangeInfo;
    }
}

