/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.utils;

import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.vise.vim.messaging.cdc.ChangeLogUpdate;
import java.util.Collection;
import org.apache.commons.logging.Log;

public class LoggingHelper {
    public static void logChanges(String string, Collection<?> collection, String string2, Log log) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((Object)String.format("[LiveRefresh] [%s] CDC number of changes: %d detected for clientId:%s", string, collection.size(), string2));
        if (log.isTraceEnabled()) {
            for (Object obj : collection) {
                ResourceChange resourceChange;
                if (obj instanceof ResourceChange) {
                    resourceChange = (ResourceChange)obj;
                    log.trace((Object)("CDC ResourceChangeKind:" + resourceChange.getKind()));
                    log.trace((Object)("CDC ResourceChange object type:" + resourceChange.getResourceType()));
                    log.trace((Object)("CDC ResourceChange object:" + resourceChange.getResource()));
                    log.trace((Object)("CDC ResourceChange properties:" + resourceChange.getProperties()));
                    continue;
                }
                if (!(obj instanceof AlarmChange)) continue;
                resourceChange = (AlarmChange)obj;
                log.trace((Object)("CDC AlarmChangeKind:" + resourceChange.getKind()));
                log.trace((Object)("CDC AlarmChange alarm:" + resourceChange.getAlarm()));
                log.trace((Object)("CDC AlarmChange overall status:" + resourceChange.getOverallStatus()));
                log.trace((Object)("CDC AlarmChange resource object:" + resourceChange.getResource()));
            }
        }
    }

    public static void logTotalProcessingForChange(ChangeLogUpdate changeLogUpdate, String string, long l, Log log) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((Object)String.format("[LiveRefresh] ClientId:%s. Total processing time for (%s) is %d milliseconds. Thread Id: [%d]", string, changeLogUpdate.id, l, Thread.currentThread().getId()));
    }
}

