/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolQueueWrapper<T>
extends ArrayBlockingQueue<T> {
    private static final Log _logger = LogFactory.getLog(ThreadPoolQueueWrapper.class);
    private static final long serialVersionUID = -4038907017718886116L;
    private final int _thirtyPercentThreshold;
    private final int _fiftyPercentThreshold;
    private final int _eightyPercentThreshold;
    private final int _ninetyPercentThreshold;
    private final int _ninetyNinePercentThreshold;
    private final int _capacity;

    public ThreadPoolQueueWrapper(int n) {
        super(n);
        this._thirtyPercentThreshold = Math.max(1, (int)((double)n * 0.3));
        this._fiftyPercentThreshold = Math.max(1, n / 2);
        this._eightyPercentThreshold = Math.max(1, (int)((double)n * 0.8));
        this._ninetyPercentThreshold = Math.max(1, (int)((double)n * 0.9));
        this._ninetyNinePercentThreshold = Math.max(1, (int)((double)n * 0.99));
        this._capacity = n;
    }

    @Override
    public boolean offer(T t) {
        boolean bl = super.offer(t);
        this.checkThreshold();
        return bl;
    }

    @Override
    public boolean offer(T t, long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl = super.offer(t, l, timeUnit);
        this.checkThreshold();
        return bl;
    }

    @Override
    public void put(T t) throws InterruptedException {
        super.put(t);
        this.checkThreshold();
    }

    @Override
    public boolean add(T t) {
        boolean bl = super.add(t);
        this.checkThreshold();
        return bl;
    }

    private void checkThreshold() {
        int n = this.size();
        int n2 = this.remainingCapacity();
        if (n == this._thirtyPercentThreshold) {
            _logger.info((Object)("Thirty percent of the queue capacity is reached. queueSize: " + n + ", remainingCapacity: " + n2));
        } else if (n == this._fiftyPercentThreshold) {
            _logger.warn((Object)("Fifty percent of the queue capacity is reached. queueSize: " + n + ", remainingCapacity: " + n2));
        } else if (n == this._eightyPercentThreshold) {
            _logger.warn((Object)("Eighty percent of the queue capacity is reached. queueSize: " + n + ", remainingCapacity: " + n2));
        } else if (n == this._ninetyPercentThreshold) {
            _logger.warn((Object)("Ninety percent of the queue capacity is reached. queueSize: " + n + ", remainingCapacity: " + n2));
        } else if (n == this._ninetyNinePercentThreshold) {
            _logger.warn((Object)("Ninety nine percent of the queue capacity is reached. queueSize: " + n + ", remainingCapacity: " + n2));
        } else if (n == this._capacity) {
            _logger.warn((Object)("The queue is full. queueSize: " + n + ", remainingCapacity: " + n2));
        }
    }
}

