/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.provider;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.provider.ProviderMethodNotFoundException;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DelegatingServiceBase {
    private static final String NULL_METHOD_NAME = "NULL_METHOD_NAME_FOR_METHODS_BY_NAME";
    private static final MethodInfo NULL_METHOD_INFO = new MethodInfo(null, null, null);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final ConcurrentMap<String, ConcurrentMap<String, MethodInfo>> _methodsByName = new ConcurrentHashMap<String, ConcurrentMap<String, MethodInfo>>();
    private final ServiceRegistry _serviceRegistry;
    private final Class<?> _markerInterface;

    public DelegatingServiceBase(Class<?> clazz, ServiceRegistry serviceRegistry) {
        this._markerInterface = clazz;
        this._serviceRegistry = serviceRegistry;
        this._serviceRegistry.registerServiceListener(this._markerInterface.getName(), new ServiceListener(){

            public void serviceAdded(Object object) {
                DelegatingServiceBase.this.clearCache();
            }

            public void serviceRemoved(Object object) {
                DelegatingServiceBase.this.clearCache();
            }
        });
    }

    public <T> T delegate(String string, Object ... objectArray) throws ProviderMethodNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T t = this.invokeProviderInternal(string, DelegatingServiceBase.getParamsTypes(objectArray), DelegatingServiceBase.getParamsReferenceTypes(objectArray), objectArray);
        return t;
    }

    private void clearCache() {
        this._methodsByName.clear();
    }

    private MethodInfo getMethodInfo(String string, Class<?>[] classArray, String[] stringArray) {
        Object object;
        Object object2;
        if (string == null) {
            string = NULL_METHOD_NAME;
        }
        if ((object2 = (ConcurrentHashMap)this._methodsByName.get(string)) == null && (object = (ConcurrentMap)this._methodsByName.putIfAbsent(string, (ConcurrentMap<String, MethodInfo>)(object2 = new ConcurrentHashMap(7)))) != null) {
            object2 = object;
        }
        if ((object = DelegatingServiceBase.getParamSignature(classArray, stringArray)) == null) {
            throw new IllegalStateException("Null param signature");
        }
        MethodInfo methodInfo = (MethodInfo)object2.get(object);
        if (methodInfo == null) {
            MethodInfo methodInfo2;
            methodInfo = this.lookupMethodInfo(string, classArray, stringArray);
            if (methodInfo == null) {
                methodInfo = NULL_METHOD_INFO;
            }
            if ((methodInfo2 = object2.putIfAbsent(object, methodInfo)) != null) {
                methodInfo = methodInfo2;
            }
        }
        if (methodInfo == NULL_METHOD_INFO) {
            return null;
        }
        return methodInfo;
    }

    private static String getParamSignature(Class<?>[] classArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append("ref." + string + "|");
        }
        for (Class<?> clazz : classArray) {
            String string = clazz.getName();
            stringBuffer.append(string + "|");
        }
        String string = stringBuffer.toString();
        return string;
    }

    private MethodInfo lookupMethodInfo(String string, Class<?>[] classArray, String[] stringArray) {
        List list = this._serviceRegistry.getServices(this._markerInterface.getName());
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        for (Object e : list) {
            try {
                MethodInfo methodInfo = DelegatingServiceBase.getCompatibleMethod(e, string, classArray, stringArray);
                arrayList.add(methodInfo);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        MethodInfo methodInfo = DelegatingServiceBase.findBestMatch(arrayList);
        return methodInfo;
    }

    private static MethodInfo findBestMatch(List<MethodInfo> list) {
        MethodInfo methodInfo = null;
        for (MethodInfo methodInfo2 : list) {
            if (methodInfo2.typeMapping == null) {
                methodInfo = methodInfo2;
                continue;
            }
            return methodInfo2;
        }
        return methodInfo;
    }

    private static MethodInfo getCompatibleMethod(Object object, String string, Class<?>[] classArray, String[] stringArray) throws NoSuchMethodException {
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray == null) {
            throw new NoSuchMethodException(string + " not found.");
        }
        MethodInfo methodInfo = null;
        for (Method method : methodArray) {
            type type2;
            Class<?>[] classArray2;
            if (Modifier.isPrivate(method.getModifiers()) || !string.equals(method.getName()) || (classArray2 = method.getParameterTypes()) == null || classArray2.length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].equals(classArray[i]) || classArray[i].isAssignableFrom(classArray2[i]) || classArray2[i].isAssignableFrom(classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl || !DelegatingServiceBase.isTypeMappingSuccess(type2 = method.getAnnotation(type.class), stringArray).booleanValue()) continue;
            if (type2 != null) {
                methodInfo = new MethodInfo(object, method, type2);
                break;
            }
            methodInfo = new MethodInfo(object, method, type2);
        }
        if (methodInfo != null) {
            return methodInfo;
        }
        throw new NoSuchMethodException(string + " not found.");
    }

    private static Boolean isTypeMappingSuccess(type type2, String[] stringArray) {
        String[] stringArray2;
        if (type2 == null) {
            return true;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return false;
        }
        for (String string : stringArray2 = type2.value().split(",")) {
            if (!string.equals(stringArray[0])) continue;
            return true;
        }
        return false;
    }

    private <T> T invokeProviderInternal(String string, Class<?>[] classArray, String[] stringArray, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ProviderMethodNotFoundException {
        MethodInfo methodInfo = this.getMethodInfo(string, classArray, stringArray);
        if (methodInfo == null) {
            throw new ProviderMethodNotFoundException(string, classArray, stringArray);
        }
        return (T)methodInfo.method.invoke(methodInfo.provider, objectArray);
    }

    protected static OperationResult toOperationResult(Exception exception) {
        OperationResult operationResult = new OperationResult();
        operationResult.error = exception;
        return operationResult;
    }

    private static Class<?>[] getParamsTypes(Object ... objectArray) {
        Class<?>[] classArray = null;
        if (objectArray != null && objectArray.length > 0) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                classArray[i] = object.getClass();
            }
        } else {
            classArray = EMPTY_CLASS_ARRAY;
        }
        return classArray;
    }

    private static String[] getParamsReferenceTypes(Object ... objectArray) {
        String[] stringArray = StringUtil.EMPTY_STRING_ARR;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return stringArray;
        }
        Object object = objectArray[0];
        if (object == null) {
            return stringArray;
        }
        String string = QueryUtil.getReferenceType((Object)object);
        if (string == null) {
            return stringArray;
        }
        stringArray = new String[]{string};
        return stringArray;
    }

    protected static void checkValidSpec(Object object) throws IllegalArgumentException {
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("The spec parameter cannot be null");
    }

    private static class MethodInfo {
        public final type typeMapping;
        public final Object provider;
        public final Method method;

        public MethodInfo(Object object, Method method, type type2) {
            this.provider = object;
            this.method = method;
            this.typeMapping = type2;
        }
    }
}

