/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;

public class ScheduledOpsPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    public ScheduledOpsPropertyProvider(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,HostProfile,Network,")
    public ResultSet getAllScheduledTasks(ManagedObjectReference managedObjectReference) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint("scheduledTask", (Constraint)objectIdentityConstraint, Boolean.valueOf(true), "vsphere:ScheduledTask");
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)relationalConstraint, new String[]{"scheduledTaskInfo"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        return response.resultSet[0];
    }

    @type(value="ScheduledTask")
    public ResultSet getScheduledTaskExecutionInfo(ManagedObjectReference managedObjectReference) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        objectIdentityConstraint.targetType = "vsphere:ScheduledTask";
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)objectIdentityConstraint, new String[]{"scheduledTaskExecutionInfo"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        return response.resultSet[0];
    }

    @type(value="ScheduledTask")
    public ResultSet getScheduledTaskInfo(ManagedObjectReference managedObjectReference) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        objectIdentityConstraint.targetType = "vsphere:ScheduledTask";
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)objectIdentityConstraint, new String[]{"scheduledTaskInfo"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        return response.resultSet[0];
    }
}

