/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.http.HttpUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SameOriginFilterWebconsole
implements Filter {
    private static ConfigurationService _configurationService = null;
    private static final String SAME_ORIGIN_FLAG = "sameOrigin.check";
    private static final Log _logger = LogFactory.getLog(SameOriginFilterWebconsole.class);

    public SameOriginFilterWebconsole() {
    }

    public SameOriginFilterWebconsole(ConfigurationService configurationService) {
        SameOriginFilterWebconsole.initializeConfigObject(configurationService);
    }

    private static void initializeConfigObject(ConfigurationService configurationService) {
        _configurationService = configurationService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Boolean bl = Boolean.valueOf(_configurationService.getProperty(SAME_ORIGIN_FLAG));
        _logger.info((Object)("Same Origin Check Enabled:: " + bl));
        if (bl.booleanValue() && !HttpUtil.isSameOrigin((HttpServletRequest)httpServletRequest)) {
            httpServletResponse.sendError(403);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }
}

