/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.springframework.http.HttpMethod;

public class SessionManagementFilter
implements Filter {
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    private static final String HSTS_HEADER_NAME = "Strict-Transport-Security";
    private static final long HSTS_DEFAULT_MAX_AGE_SECONDS = 30758400L;
    private static final String X_FRAME_OPTIONS_HEADER_NAME = "X-Frame-Options";
    private static final long REQUEST_PROCESSING_TIME_THRESHOLD = TimeUnit.SECONDS.toNanos(30L);
    private final boolean _isH5Client = BuildProperties.isH5Client();
    private boolean _hstsEnabled;
    private long _hstsMaxAgeSeconds;
    private boolean _hstsIncludeSubdomains;
    private boolean _xsrfProtectionEnabled;
    private String _xsrfCookieName;
    private String _xsrfHeaderName;
    private boolean _xFrameOptionsEnabled;

    private String getInitParameter(FilterConfig filterConfig, Parameter parameter, Object object) {
        String string = filterConfig.getInitParameter(parameter.getName());
        if (string == null) {
            return String.valueOf(object);
        }
        return string;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._hstsEnabled = Boolean.parseBoolean(this.getInitParameter(filterConfig, Parameter.HSTS_ENABLED, false));
        this._hstsIncludeSubdomains = Boolean.parseBoolean(this.getInitParameter(filterConfig, Parameter.HSTS_INCLUDE_SUBDOMAINS, true));
        this._hstsMaxAgeSeconds = Long.parseLong(this.getInitParameter(filterConfig, Parameter.HSTS_MAX_AGE_SECONDS, 30758400L));
        this._xsrfCookieName = this.getInitParameter(filterConfig, Parameter.XSRF_COOKIE_NAME, BuildProperties.getXsrfCookieName());
        this._xsrfHeaderName = this.getInitParameter(filterConfig, Parameter.XSRF_HEADER_NAME, BuildProperties.getXsrfHeaderName());
        this._xsrfProtectionEnabled = Boolean.parseBoolean(this.getInitParameter(filterConfig, Parameter.XSRF_PROTECTION_ENABLED, false));
        this._xFrameOptionsEnabled = Boolean.parseBoolean(this.getInitParameter(filterConfig, Parameter.X_FRAME_OPTIONS_ENABLED, false));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        OpIdUtil.getOrGenerateOpIdPrefix((HttpServletRequest)httpServletRequest);
        long l = System.nanoTime();
        Exception exception = null;
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
            this.addHstsHeader(httpServletRequest, httpServletResponse);
            String string = httpServletRequest.getRequestURI();
            if (this._isH5Client || string.endsWith(".html")) {
                HttpSession httpSession = httpServletRequest.getSession(true);
                String string2 = this.extractClientId(httpServletRequest);
                if (!(string2 == null || this.isClientIdValid(string2, httpSession) && this.isSessionAuthenticated(httpSession))) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                String string3 = SessionUtil.getClientId((HttpSession)httpSession);
                if (this._xsrfProtectionEnabled && string3 != null) {
                    String string4 = (String)SessionUtil.getData((String)this._xsrfCookieName, (String)string3);
                    if (string4 == null) {
                        Cookie cookie = this.createXsrfCookie();
                        SessionUtil.setData((String)this._xsrfCookieName, (Object)cookie.getValue(), (String)string3);
                        httpServletResponse.addCookie(cookie);
                    } else if (!this.isRequestXsrfTokenValid(httpServletRequest, string4)) {
                        httpServletResponse.setStatus(401);
                        return;
                    }
                }
                if (this._xFrameOptionsEnabled) {
                    httpServletResponse.setHeader(X_FRAME_OPTIONS_HEADER_NAME, "deny");
                }
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception2) {
            exception = exception2;
            throw exception2;
        }
        finally {
            SessionUtil.setHttpRequest(null);
            long l2 = System.nanoTime() - l;
            SessionManagementFilter.logWarningIfNecessary(httpServletRequest, l2, REQUEST_PROCESSING_TIME_THRESHOLD, exception);
        }
    }

    public void destroy() {
    }

    private void addHstsHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this._hstsEnabled && httpServletRequest.isSecure()) {
            String string = String.format("max-age=%d", this._hstsMaxAgeSeconds);
            if (this._hstsIncludeSubdomains) {
                string = string + "; includeSubDomains";
            }
            httpServletResponse.setHeader(HSTS_HEADER_NAME, string);
        }
    }

    private boolean isSessionAuthenticated(HttpSession httpSession) {
        return !SessionUtil.isLogoutInitiated((HttpSession)httpSession) && !SessionUtil.isAssociatedWithInvalidClientId((HttpSession)httpSession);
    }

    private boolean isClientIdValid(String string, HttpSession httpSession) {
        try {
            UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        String string2 = SessionUtil.getClientId((HttpSession)httpSession);
        if (!string.equals(string2)) {
            SessionUtil.associateSessionWithClientId((HttpSession)httpSession, (String)string);
            return true;
        }
        return SessionUtil.isValidClientId((String)string);
    }

    private String extractClientId(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("webClientSessionId");
        if (string == null) {
            string = httpServletRequest.getParameter("webClientSessionId");
        }
        return string;
    }

    private Cookie createXsrfCookie() {
        String string = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(this._xsrfCookieName, string);
        cookie.setMaxAge(-1);
        cookie.setSecure(true);
        return cookie;
    }

    private boolean isRequestXsrfTokenValid(HttpServletRequest httpServletRequest, String string) {
        String string2;
        String string3 = httpServletRequest.getMethod();
        return !HttpMethod.POST.name().equals(string3) && !HttpMethod.PUT.name().equals(string3) && !HttpMethod.DELETE.name().equals(string3) || (string2 = httpServletRequest.getHeader(this._xsrfHeaderName)) != null && string.equals(string2);
    }

    public static void logWarningIfNecessary(HttpServletRequest httpServletRequest, long l, long l2, Exception exception) {
        if (l <= l2 && !_opIdLogger.isDebugEnabled() && exception == null) {
            return;
        }
        String string = OpIdUtil.getOrGenerateOpIdPrefix((HttpServletRequest)httpServletRequest);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("Request processing for opId '").append(string).append("' to URL ").append(httpServletRequest.getRequestURI()).append(' ');
        long l3 = TimeUnit.NANOSECONDS.toMillis(l);
        if (exception != null) {
            stringBuilder.append("failed in ").append(l3).append(" ms");
            SessionUtil.appendRequestAddr((StringBuilder)stringBuilder, (ServletRequest)httpServletRequest, (String)", ");
            if (_opIdLogger.isDebugEnabled()) {
                _opIdLogger.error((Object)stringBuilder.toString(), (Throwable)exception);
            } else {
                stringBuilder.append(", error: ").append(exception.toString());
                _opIdLogger.error((Object)stringBuilder.toString());
            }
        } else if (l > l2) {
            stringBuilder.append("took too long: ").append(l3).append(" ms");
            SessionUtil.appendRequestAddr((StringBuilder)stringBuilder, (ServletRequest)httpServletRequest, (String)", ");
            _opIdLogger.warn((Object)stringBuilder.toString());
        } else {
            stringBuilder.append("completed in ").append(l3).append(" ms");
            SessionUtil.appendRequestAddr((StringBuilder)stringBuilder, (ServletRequest)httpServletRequest, (String)", ");
            _opIdLogger.debug((Object)stringBuilder.toString());
        }
    }

    private static enum Parameter {
        XSRF_PROTECTION_ENABLED("xsrfProtectionEnabled"),
        XSRF_COOKIE_NAME("xsrfCookieName"),
        XSRF_HEADER_NAME("xsrfHeaderName"),
        HSTS_ENABLED("hstsEnabled"),
        HSTS_INCLUDE_SUBDOMAINS("hstsIncludeSubdomains"),
        HSTS_MAX_AGE_SECONDS("hstsMaxAgeSeconds"),
        X_FRAME_OPTIONS_ENABLED("xFrameOptionsEnabled");

        private final String _parameterName;

        private Parameter(String string2) {
            this._parameterName = string2;
        }

        public String getName() {
            return this._parameterName;
        }
    }
}

