/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security.internal;

import com.vmware.vise.util.PropertyUtil;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "security-common.properties";
    public static final long DEFAULT_AUTH_PROVIDER_QCTP_EXPIRATION_THRESHOLD_MILLIS;
    public static final long THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_EXPIRED_TASK_STEP_SIZE;
    public static final long THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS;

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        DEFAULT_AUTH_PROVIDER_QCTP_EXPIRATION_THRESHOLD_MILLIS = PropertyUtil.getLongProperty((Properties)properties, (String)"DefaultAuthProvider.QueuingCachedThreadPool.expirationTimeThreshold", (long)120000L);
        THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.queueWaitTimeThreshold", (long)5000L));
        THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.delayedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.rejectedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_EXPIRED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.expiredTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.diagnostics.minTimeApart", (long)60000L));
    }
}

