/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.LastEventFilterSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HostPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String LAST_EXISTED_STANDBY_EVENT = "lastExitedStandbyEvent";
    private final DataServiceExtensionRegistry _extensionRegistry;
    private static final String[] EXIT_STANDBY_EVENT_TYPES = new String[]{"vim.event.ExitStandbyModeFailedEvent", "vim.event.DrsExitStandbyModeFailedEvent", "vim.event.ExitedStandbyModeEvent", "vim.event.DrsExitedStandbyModeEvent"};

    public HostPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        this._extensionRegistry = registry;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = HostSystem.class.getSimpleName();
        ti.properties = new String[]{LAST_EXISTED_STANDBY_EVENT};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || objects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> allResultItems = new ArrayList<ResultItem>();
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        Map<String, ArrayList<ManagedObjectReference>> objectsByServerGuid = this.createObjectMapByServerGuid(objects);
        for (String serverGuid : objectsByServerGuid.keySet()) {
            try {
                ManagedObjectReference[] mors = objectsByServerGuid.get(serverGuid).toArray(new ManagedObjectReference[0]);
                if (mors.length == 0 || !this.isPropertyRequested(LAST_EXISTED_STANDBY_EVENT, properties)) continue;
                ArrayList<ResultItem> resultItems = this.getLastExitedStandbyEventProperty(serverGuid, mors);
                for (ResultItem ri : resultItems) {
                    allResultItems.add(ri);
                }
            }
            catch (Exception ex) {
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
            }
        }
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = allResultItems.toArray(new ResultItem[0]);
        return result;
    }

    private boolean isPropertyRequested(String property, PropertySpec[] properties) {
        for (PropertySpec pSpec : properties) {
            for (String p : pSpec.propertyNames) {
                if (!property.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, ArrayList<ManagedObjectReference>> createObjectMapByServerGuid(Object[] objects) {
        HashMap<String, ArrayList<ManagedObjectReference>> objectsByServerGuid = new HashMap<String, ArrayList<ManagedObjectReference>>();
        String serverGuid = null;
        for (Object object : objects) {
            ManagedObjectReference mor;
            if (!(object instanceof ManagedObjectReference) || !(mor = (ManagedObjectReference)object).getType().equals(HostSystem.class.getSimpleName())) continue;
            serverGuid = mor.getServerGuid();
            ArrayList<Object> mors = objectsByServerGuid.get(serverGuid);
            if (mors == null) {
                mors = new ArrayList();
                objectsByServerGuid.put(serverGuid, mors);
            }
            mors.add(mor);
        }
        return objectsByServerGuid;
    }

    private ArrayList<ResultItem> getLastExitedStandbyEventProperty(String serverGuid, ManagedObjectReference[] objects) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        EventManager eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().eventManager);
        LastEventFilterSpec spec = new LastEventFilterSpec();
        spec.entity = objects;
        spec.type = EXIT_STANDBY_EVENT_TYPES;
        Event[] events = eventManager.queryLastEvent(spec);
        Map<String, Event> eventByHostMap = this.getMostRecentEventPerHost(events);
        return this.convertToResultItems(eventByHostMap);
    }

    private Map<String, Event> getMostRecentEventPerHost(Event[] events) {
        HashMap<String, Event> eventByHostMap = new HashMap<String, Event>();
        if (events == null) {
            return eventByHostMap;
        }
        for (Event ev : events) {
            if (ev.host == null || ev.host.host == null) continue;
            String moref = ManagedObjectUtil.morefToString((ManagedObjectReference)ev.host.host);
            Event oldEvent = eventByHostMap.get(moref);
            if (oldEvent != null) {
                if (oldEvent.createdTime.compareTo(ev.createdTime) >= 0) continue;
                eventByHostMap.put(moref, ev);
                continue;
            }
            eventByHostMap.put(moref, ev);
        }
        return eventByHostMap;
    }

    private ArrayList<ResultItem> convertToResultItems(Map<String, Event> eventByHostMap) {
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (String hostRefString : eventByHostMap.keySet()) {
            ManagedObjectReference mor = ManagedObjectUtil.stringToMoref((String)hostRefString);
            ResultItem ri = new ResultItem();
            ri.resourceObject = mor;
            PropertyValue pv = new PropertyValue();
            pv.resourceObject = mor;
            pv.propertyName = LAST_EXISTED_STANDBY_EVENT;
            pv.value = eventByHostMap.get(hostRefString);
            ri.properties = new PropertyValue[]{pv};
            resultItems.add(ri);
        }
        return resultItems;
    }
}

