/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.host.MemoryConfigInfo;
import com.vmware.vsphere.client.host.StorageCountInfo;
import com.vmware.vsphere.client.host.model.DatastoreParentInfo;
import java.util.HashSet;

@QueryBinding(value="HostSystem")
public class HostHardwareData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/hardware/systemInfo/vendor")
    public String manufacturer;
    @Property(value="HostSystem/hardware/systemInfo/model")
    public String model;
    @Property(value="HostSystem/hardware/cpuInfo/numCpuCores")
    public int numCpuCores;
    @Property(value="HostSystem/summary/hardware/cpuMhz")
    public int cpuMhzCapacity;
    @Property(value="HostSystem/summary/quickStats/overallCpuUsage")
    public long cpuMhzUsage;
    @Property(value="HostSystem/hardware/memorySize")
    public long memorySize;
    @Property(value="HostSystem/summary/quickStats/overallMemoryUsage")
    public int memoryUsage;
    @Property(value="HostSystem/hardware/persistentMemoryInfo.capacityInMB")
    public Long totalPmem;
    @Property(value="HostSystem/availablePMem")
    public Long freePmem;
    @Property(value="HostSystem/summary/hardware/cpuModel")
    public String cpuModel;
    @Property(value="HostSystem/hardware/cpuInfo/numCpuPackages")
    public int sockets;
    @Property(value="HostSystem/hardware/cpuInfo/numCpuThreads")
    public int logicalCpu;
    @Property(value="HostSystem/summary/hardware/numHBAs")
    public int numHBAs;
    @Property(value="HostSystem/summary/hardware/numNics")
    public int numNics;
    @Property(value="HostSystem/allNetwork/length")
    public int networkCount;
    @Property(value="HostSystem/datastore/length")
    public int datastoreCount;
    @Property(value="HostSystem/dnsConfig")
    public DnsConfig dnsConfig;
    @Property(value="HostSystem/memoryConfigInfo")
    public MemoryConfigInfo memoryConfig;
    @Property(value="HostSystem/hyperthreadingInfo")
    public CpuSchedulerSystem.HyperThreadScheduleInfo hyperthreadingInfo;
    @Property(value="HostSystem/capability/vFlashSupported")
    public boolean isVFlashSupported;
    @Property(value="HostSystem/runtime/vFlashResourceRuntimeInfo/capacity")
    public transient long vFlashResourceCapacity;
    @Property(value="HostSystem/runtime/vFlashResourceRuntimeInfo/usage")
    public transient long vFlashResourceUsage;
    @NestedQueryBinding
    @Relationship(value={"HostSystem/datastore"})
    public DatastoreParentInfo[] datastores;

    private static String formatDataSize(Number bytes, long base) {
        return FormatUtil.getDataSizeFormatted((Number)bytes, (int)2, (long)base, (long)-1L, (boolean)true);
    }

    public String getvFlashResourceCapacityText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceCapacity), 1L);
    }

    public String getvFlashResourceUsageText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceUsage), 1L);
    }

    public String getvFlashResourceFreeText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceCapacity - this.vFlashResourceUsage), 1L);
    }

    public String getCpuMhzCapacityText() {
        return FormatUtil.getFrequencyFormatted((Number)new Integer(this.cpuMhzCapacity), (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    public String getCpuUsagePercentage() {
        return String.format("%.0f", Float.valueOf((float)this.cpuMhzUsage * 100.0f / ((float)this.cpuMhzCapacity * (float)this.numCpuCores)));
    }

    public String getMemoryUsageText() {
        return HostHardwareData.formatDataSize(new Long(this.memoryUsage), 0x100000L);
    }

    public String getMemoryUsagePercentage() {
        return String.format("%.0f", Float.valueOf((float)this.memoryUsage * 1024.0f * 1024.0f * 100.0f / (float)this.memorySize));
    }

    public String getMemorySizeText() {
        return HostHardwareData.formatDataSize(new Long(this.memorySize), 1L);
    }

    public String getPmemUsageText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return HostHardwareData.formatDataSize(0, 0x100000L);
        }
        return HostHardwareData.formatDataSize(this.totalPmem - this.freePmem, 0x100000L);
    }

    public String getPmemUsagePercentage() {
        if (this.totalPmem == null || this.freePmem == null || this.totalPmem == 0L) {
            return String.format("%.0f", 0.0);
        }
        return String.format("%.0f", Float.valueOf((float)(this.totalPmem - this.freePmem) * 100.0f / (float)this.totalPmem.longValue()));
    }

    public String getPmemSizeText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return HostHardwareData.formatDataSize(0, 0x100000L);
        }
        return HostHardwareData.formatDataSize(this.totalPmem, 0x100000L);
    }

    public StorageCountInfo getStorageCountInfo() {
        StorageCountInfo storageCountInfo = new StorageCountInfo();
        HashSet<String> storagePodSet = new HashSet<String>();
        String storagePodName = StoragePod.class.getSimpleName();
        if (this.datastores != null) {
            for (DatastoreParentInfo datastore : this.datastores) {
                ManagedObjectReference datastoreParent = datastore.parent;
                if (storagePodName.equals(datastoreParent.getType())) {
                    storagePodSet.add(datastoreParent.getValue());
                    continue;
                }
                ++storageCountInfo.standaloneDatastoreCount;
            }
            storageCountInfo.storagePodCount = storagePodSet.size();
        }
        return storageCountInfo;
    }
}

