/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample;

import com.vmware.samples.htmlsample.model.Chassis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FakeChassisStore {
    private static final int CHASSIS_INITIAL_COUNT = 4;
    private static final String CHASSIS_ID = "chassis:%s";
    private static final String CHASSIS_NAME = "Chassis %s";
    private static final String CHASSIS_SERVER_TYPE = "Server_Type %s";
    private static final String CHASSIS_DIMENSIONS = "20in x 30in x 17in";
    private static int _index = 0;
    private Map<String, Chassis> _fakeStore;

    public void init() {
        HashMap hashMap = new HashMap(4);
        this._fakeStore = Collections.synchronizedMap(hashMap);
        for (int i = 0; i < 4; ++i) {
            Chassis chassis = new Chassis();
            chassis.name = String.format(CHASSIS_NAME, i);
            chassis.serverType = String.format(CHASSIS_SERVER_TYPE, i);
            chassis.dimensions = CHASSIS_DIMENSIONS;
            chassis.isActive = false;
            this.create(chassis);
        }
    }

    public void destroy() {
        this._fakeStore.clear();
    }

    public List<Chassis> getObjects() {
        return new ArrayList<Chassis>(this._fakeStore.values());
    }

    public Chassis getObjectById(String string) {
        if (string == null) {
            return null;
        }
        return this._fakeStore.get(string);
    }

    public Chassis create(Chassis chassis) {
        if (chassis == null || !this.isNameUnique(chassis.name)) {
            return null;
        }
        chassis.id = FakeChassisStore.generateId();
        this._fakeStore.put(chassis.id, chassis);
        return chassis;
    }

    public boolean update(Chassis chassis) {
        if (chassis == null) {
            return false;
        }
        boolean bl = chassis.name.equals(this._fakeStore.get((Object)chassis.id).name);
        if (!bl && !this.isNameUnique(chassis.name)) {
            return false;
        }
        Chassis chassis2 = this._fakeStore.put(chassis.id, chassis);
        return chassis2 != null;
    }

    public Chassis delete(String string) {
        if (string == null) {
            return null;
        }
        return this._fakeStore.remove(string);
    }

    private static String generateId() {
        return String.format(CHASSIS_ID, _index++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNameUnique(String string) {
        Map<String, Chassis> map = this._fakeStore;
        synchronized (map) {
            for (Chassis chassis : this._fakeStore.values()) {
                if (!string.equals(chassis.name)) continue;
                return false;
            }
            return true;
        }
    }
}

