/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.controllers;

import com.vmware.samples.htmlsample.controllers.BaseRestController;
import com.vmware.samples.htmlsample.model.Chassis;
import com.vmware.samples.htmlsample.services.ChassisService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ChassisController
extends BaseRestController {
    private final ChassisService _chassisService;

    @Autowired
    public ChassisController(ChassisService chassisService) {
        this._chassisService = chassisService;
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Chassis getChassisById(@PathVariable(value="objectId") String string) throws Exception {
        return this._chassisService.getChassisById(string);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Chassis> getChassisList() throws Exception {
        return this._chassisService.getAllChassis();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public String create(@RequestBody Chassis chassis) {
        return this._chassisService.create(chassis);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean edit(@RequestBody Chassis chassis) {
        return this._chassisService.update(chassis);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean delete(@RequestBody String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            bl = this._chassisService.delete(string) || bl;
        }
        return bl;
    }

    @RequestMapping(value={"/vm-headless-action"}, method={RequestMethod.POST})
    @ResponseBody
    public void vmHeadlessAction() {
    }
}

