/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.services;

import com.vmware.samples.htmlsample.FakeChassisStore;
import com.vmware.samples.htmlsample.model.Chassis;
import com.vmware.samples.htmlsample.services.ChassisService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChassisServiceImpl
implements ChassisService {
    private static final String CHASSIS_OBJECT_IS_NULL_LOG_MSG = "Chassis object is null.";
    private static final String CHASSIS_OBJECT_EXISTS_LOG_MSG = "Chassis object with the name '%s' already exists.";
    private static final String CHASSIS_OBJECT_DOES_NOT_EXIST_LOG_MSG = "Chassis object with the ID '%s' does not exist.";
    private static final String CHASSIS_OBJECT_CREATED_LOG_MSG = "Chassis object with the ID '%s' was successfully created: '%s'.";
    private static final Log _logger = LogFactory.getLog(ChassisServiceImpl.class);
    private final FakeChassisStore _fakeChassisStore;

    public ChassisServiceImpl(FakeChassisStore fakeChassisStore) {
        this._fakeChassisStore = fakeChassisStore;
    }

    @Override
    public Chassis getChassisById(String string) {
        return this._fakeChassisStore.getObjectById(string);
    }

    @Override
    public List<Chassis> getAllChassis() {
        return this._fakeChassisStore.getObjects();
    }

    @Override
    public String create(Chassis chassis) {
        if (chassis == null) {
            _logger.info((Object)CHASSIS_OBJECT_IS_NULL_LOG_MSG);
            return null;
        }
        Chassis chassis2 = this._fakeChassisStore.create(chassis);
        if (chassis2 == null) {
            _logger.info((Object)String.format(CHASSIS_OBJECT_EXISTS_LOG_MSG, chassis.name));
            return null;
        }
        _logger.info((Object)String.format(CHASSIS_OBJECT_CREATED_LOG_MSG, chassis2.id, chassis2.toString()));
        return chassis2.id;
    }

    @Override
    public boolean update(Chassis chassis) {
        Chassis chassis2 = this._fakeChassisStore.getObjectById(chassis.id);
        if (chassis2 == null) {
            _logger.info((Object)String.format(CHASSIS_OBJECT_DOES_NOT_EXIST_LOG_MSG, chassis.id));
            return false;
        }
        return this._fakeChassisStore.update(chassis);
    }

    @Override
    public boolean delete(String string) {
        Chassis chassis = this._fakeChassisStore.delete(string);
        if (chassis == null) {
            _logger.info((Object)String.format(CHASSIS_OBJECT_DOES_NOT_EXIST_LOG_MSG, string));
            return false;
        }
        return true;
    }
}

