/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.services;

import com.vmware.samples.htmlsample.model.Chassis;
import com.vmware.samples.htmlsample.model.Host;
import com.vmware.samples.htmlsample.services.HostService;
import com.vmware.samples.htmlsample.vim25.services.VimObjectService;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostServiceImpl
implements HostService {
    private final UserSessionService _userSessionService;
    private final VimObjectService _vimObjectService;
    private static final Log _logger = LogFactory.getLog(HostServiceImpl.class);

    public HostServiceImpl(UserSessionService userSessionService, VimObjectService vimObjectService) {
        this._userSessionService = userSessionService;
        this._vimObjectService = vimObjectService;
    }

    @Override
    public List<Host> getRelatedHosts(Chassis chassis) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        if (this._userSessionService.getUserSession() == null || chassis == null) {
            _logger.warn((Object)String.format("The %s is not defined.", chassis == null ? "chassis" : "UserSession"));
            return arrayList;
        }
        for (ServerInfo serverInfo : this._userSessionService.getUserSession().serversInfo) {
            List<Host> list = this._vimObjectService.retrieveHosts(serverInfo);
            arrayList.addAll(list);
        }
        List<Host> list = this.getConnectedHosts(arrayList);
        return list;
    }

    private List<Host> getConnectedHosts(List<Host> list) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        for (Host host : list) {
            if (!"connected".equals(host.state)) continue;
            host.state = Character.toUpperCase(host.state.charAt(0)) + host.state.substring(1);
            arrayList.add(host);
        }
        return arrayList;
    }
}

