/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.vim25.services;

import com.vmware.samples.htmlsample.model.Host;
import com.vmware.samples.htmlsample.vim25.services.VimObjectService;
import com.vmware.samples.htmlsample.vim25.ssl.TrustedService;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vise.usersession.ServerInfo;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimObjectServiceImpl
implements VimObjectService {
    private static final Log _logger = LogFactory.getLog(VimObjectServiceImpl.class);
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private static final String NAME = "name";
    private static final String HOST = "HostSystem";
    private static final String OBJECT_ID_FORMAT = "urn:vmomi:%s:%s:%s";
    private static final String HOST_SUMMARY = "summary.host";
    private static final String HOST_CONNECTION_STATE = "runtime.connectionState";
    private static final String NUM_CPU_CORES = "hardware.cpuInfo.numCpuCores";
    private static final String MEMORY_SIZE = "systemResources.config.memoryAllocation.limit";
    private static final String[] HOST_PROPERTIES = new String[]{"name", "summary.host", "hardware.cpuInfo.numCpuCores", "runtime.connectionState", "systemResources.config.memoryAllocation.limit"};
    private static VimPortType _vimPort = VimObjectServiceImpl.initializeVimPort();

    private static VimPortType initializeVimPort() {
        VimService vimService = new VimService();
        VimPortType vimPortType = vimService.getVimPort();
        Map map = ((BindingProvider)vimPortType).getRequestContext();
        try {
            SSLSocketFactory sSLSocketFactory = TrustedService.getSSLSocketFactory();
            map.put(SSL_SOCKET_FACTORY, sSLSocketFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            _logger.error((Object)"Could not setup SSLSocketFactory in the context.", (Throwable)generalSecurityException);
        }
        return vimPortType;
    }

    private void destroy() {
        _vimPort = null;
    }

    @Override
    public List<Host> retrieveHosts(ServerInfo serverInfo) {
        VimObjectServiceImpl.paramsNotNull(serverInfo);
        List<Map<String, Object>> list = this.retrieveObjectProperties(serverInfo, HOST, HOST_PROPERTIES);
        List<Host> list2 = this.transformHostsPropertiesToObjects(list, serverInfo);
        return list2;
    }

    @Override
    public List<Map<String, Object>> retrieveObjectProperties(ServerInfo serverInfo, String string, String[] stringArray) {
        VimObjectServiceImpl.paramsNotNull(serverInfo, string, stringArray);
        ServiceContent serviceContent = null;
        try {
            serviceContent = this.getServiceContentWithSessionCookie(serverInfo);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            _logger.warn((Object)"Could not retrieve the ServiceContent using sessionCookie", (Throwable)runtimeFaultFaultMsg);
        }
        if (serviceContent == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ManagedObjectReference managedObjectReference = serviceContent.getViewManager();
        ManagedObjectReference managedObjectReference2 = serviceContent.getPropertyCollector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        RetrieveResult retrieveResult = null;
        try {
            ManagedObjectReference managedObjectReference3 = _vimPort.createContainerView(managedObjectReference, serviceContent.getRootFolder(), arrayList, true);
            retrieveResult = this.retrieveProperties(managedObjectReference3, managedObjectReference2, string, stringArray);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            _logger.error((Object)("Could not create ContainerView for " + string), (Throwable)runtimeFaultFaultMsg);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            _logger.error((Object)("Could not retrieveProperties for " + string), (Throwable)invalidPropertyFaultMsg);
        }
        return this.formatRetrievedProperties(retrieveResult);
    }

    private List<Host> transformHostsPropertiesToObjects(List<Map<String, Object>> list, ServerInfo serverInfo) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        for (Map<String, Object> map : list) {
            String string = this.getFormattedObjectId(map, serverInfo.serviceGuid);
            String string2 = this.getHostConnectionState(map);
            Object object = map.get(NUM_CPU_CORES);
            Object object2 = map.get(MEMORY_SIZE);
            String string3 = object == null ? "" : object.toString();
            String string4 = object2 == null ? "" : object2.toString();
            Host host = new Host(string, (String)map.get(NAME), string2, serverInfo.name, string4, string3);
            arrayList.add(host);
        }
        return arrayList;
    }

    private String getFormattedObjectId(Map<String, Object> map, String string) {
        String string2 = ((ManagedObjectReference)map.get(HOST_SUMMARY)).getValue();
        String string3 = String.format(OBJECT_ID_FORMAT, HOST, string2, string);
        return string3;
    }

    private String getHostConnectionState(Map<String, Object> map) {
        HostSystemConnectionState hostSystemConnectionState = (HostSystemConnectionState)map.get(HOST_CONNECTION_STATE);
        return hostSystemConnectionState == null ? "" : hostSystemConnectionState.value();
    }

    private ServiceContent getServiceContentWithSessionCookie(ServerInfo serverInfo) throws RuntimeFaultFaultMsg {
        TrustedService.setThumbprint(serverInfo);
        ManagedObjectReference managedObjectReference = this.createSvcInstanceRef(serverInfo.serviceUrl, serverInfo.sessionCookie);
        ServiceContent serviceContent = _vimPort.retrieveServiceContent(managedObjectReference);
        return serviceContent;
    }

    private ManagedObjectReference createSvcInstanceRef(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("vmware_soap_session=" + string2);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put("Cookie", arrayList);
        Map map = ((BindingProvider)_vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string);
        map.put("javax.xml.ws.session.maintain", true);
        map.put("javax.xml.ws.http.request.headers", hashMap);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType(SERVICE_INSTANCE);
        managedObjectReference.setValue(SERVICE_INSTANCE);
        return managedObjectReference;
    }

    private RetrieveResult retrieveProperties(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, String string, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        PropertyFilterSpec propertyFilterSpec = this.createPropertyFilterSpec(managedObjectReference, string, stringArray);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        RetrieveResult retrieveResult = _vimPort.retrievePropertiesEx(managedObjectReference2, arrayList, retrieveOptions);
        return retrieveResult;
    }

    private PropertyFilterSpec createPropertyFilterSpec(ManagedObjectReference managedObjectReference, String string, String[] stringArray) {
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("traverseEntities");
        traversalSpec.setPath("view");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType("ContainerView");
        objectSpec.getSelectSet().add(traversalSpec);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setType(string);
        propertySpec.getPathSet().addAll(Arrays.asList(stringArray));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getObjectSet().add(objectSpec);
        propertyFilterSpec.getPropSet().add(propertySpec);
        return propertyFilterSpec;
    }

    private List<Map<String, Object>> formatRetrievedProperties(RetrieveResult retrieveResult) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (retrieveResult != null) {
            for (ObjectContent objectContent : retrieveResult.getObjects()) {
                List list = objectContent.getPropSet();
                HashMap<String, Object> hashMap = new HashMap<String, Object>(list.size());
                if (list != null) {
                    for (DynamicProperty dynamicProperty : list) {
                        hashMap.put(dynamicProperty.getName(), dynamicProperty.getVal());
                    }
                }
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    public static void paramsNotNull(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Null argument args");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Null param at index: " + i);
        }
    }
}

