/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.htmlsample.vim25.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final String ERROR_MSG = "Server certificate chain is not trusted and thumbprint doesn't match";
    private static final Log _logger = LogFactory.getLog(ThumbprintTrustManager.class);
    private static final Set<String> _thumbprints = new CopyOnWriteArraySet<String>();

    public static boolean addThumbprint(String string) {
        return _thumbprints.add(string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            ThumbprintTrustManager.checkThumbprint(x509Certificate);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    public static void checkThumbprint(X509Certificate x509Certificate) throws CertificateException {
        String string = ThumbprintTrustManager.getThumbprint(x509Certificate);
        if (!_thumbprints.contains(string)) {
            _logger.error((Object)ERROR_MSG);
            throw new CertificateException(ERROR_MSG);
        }
    }

    private static String getThumbprint(X509Certificate x509Certificate) throws CertificateException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = x509Certificate.getEncoded();
            byte[] byArray2 = messageDigest.digest(byArray);
            String string = DatatypeConverter.printHexBinary((byte[])byArray2).toLowerCase();
            return string;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.error((Object)ERROR_MSG);
            throw new CertificateException(ERROR_MSG);
        }
    }
}

