/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.ExtendedFault;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.MutableMessageException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThrowableProxy
extends flex.messaging.io.ThrowableProxy {
    private static final String RES_BUNDLE_NAME = "vimamfext";
    static final long serialVersionUID = -6786265115906818980L;
    static final String PROPERTY_NAME_MESSAGE = "message";
    static final String PROPERTY_NAME_LOCALIZED_MESSAGE = "lmsg";
    static final String PROPERTY_UNEXPECTED_STATUS_CODE = "unexpectedStatusCode";
    private static final Log _logger = LogFactory.getLog(ThrowableProxy.class);
    private final DataService _dataService;
    private final NotAuthenticatedError _notAuthenticatedError;
    public final ThreadLocal<Locale> locale = new ThreadLocal();
    public final ThreadLocal<Boolean> canInvokeRequests = new ThreadLocal();

    public ThrowableProxy(DataService dataService) {
        this(null, dataService);
    }

    public ThrowableProxy(Throwable throwable, DataService dataService) {
        super(throwable);
        this._dataService = dataService;
        this._notAuthenticatedError = new NotAuthenticatedError();
    }

    public Object clone() {
        ThrowableProxy throwableProxy = new ThrowableProxy(this._dataService);
        throwableProxy.setCloneFieldsFrom((AbstractProxy)this);
        return throwableProxy;
    }

    public List<String> getPropertyNames(Object object) {
        if (object == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(super.getPropertyNames(object));
        if (object instanceof Throwable) {
            arrayList.remove("localizedMessage");
            arrayList.remove("cause");
            arrayList.remove("faultCause");
            arrayList.remove("suppressed");
        }
        if ((object instanceof MethodFault || object instanceof RuntimeFault) && !arrayList.contains(PROPERTY_NAME_LOCALIZED_MESSAGE)) {
            arrayList.add(PROPERTY_NAME_LOCALIZED_MESSAGE);
        }
        if (object.getClass() == MethodFault.class && !arrayList.contains(PROPERTY_UNEXPECTED_STATUS_CODE)) {
            arrayList.add(PROPERTY_UNEXPECTED_STATUS_CODE);
        }
        return arrayList;
    }

    public Object getValue(Object object, String string) {
        if (PROPERTY_NAME_MESSAGE.equals(string)) {
            return this.getDetailedFaultMessage(object);
        }
        if (PROPERTY_NAME_LOCALIZED_MESSAGE.equals(string)) {
            return this.getLocalizedFaultMessage((Throwable)object);
        }
        if (PROPERTY_UNEXPECTED_STATUS_CODE.equals(string)) {
            return this.getStatusCode(object);
        }
        Object object2 = super.getValue(object, string);
        return object2;
    }

    public Object getInstanceToSerialize(Object object) {
        if (object == null || !(object instanceof Throwable)) {
            return object;
        }
        if (Exception.class.getName().equals(object.getClass().getName())) {
            Exception exception = (Exception)object;
            return new MutableMessageException(exception.getMessage());
        }
        Object object2 = object;
        if (object2 instanceof Throwable && (ExceptionUtil.isCausedBy((Throwable)((Throwable)object), SessionDataContainerMissingException.class) || ExceptionUtil.isCausedBy((Throwable)((Throwable)object), SessionInvalidatedException.class))) {
            object2 = this._notAuthenticatedError;
        }
        if (MethodFault.class.equals(object.getClass()) && !((object2 = ((Throwable)object).getCause()) instanceof MethodFault) && !(object2 instanceof RuntimeFault)) {
            object2 = object;
        }
        return object2;
    }

    private Object getStatusCode(Object object) {
        if (object.getClass() != MethodFault.class) {
            return 0;
        }
        MethodFault methodFault = (MethodFault)object;
        if (!(methodFault.getCause() instanceof UnexpectedStatusCodeException)) {
            return 0;
        }
        UnexpectedStatusCodeException unexpectedStatusCodeException = (UnexpectedStatusCodeException)methodFault.getCause();
        return unexpectedStatusCodeException.getStatusCode();
    }

    private Object getDetailedFaultMessage(Object object) {
        RuntimeFault runtimeFault;
        String string;
        Object object2 = super.getValue(object, PROPERTY_NAME_MESSAGE);
        if (!(object instanceof Throwable)) {
            return object2;
        }
        if (object instanceof CompositeException) {
            CompositeException compositeException = (CompositeException)object;
            String string2 = this.buildCompositeExceptionMessage(compositeException);
            if (!StringUtil.isNullOrEmpty((String)string2)) {
                object2 = string2;
            }
            return object2;
        }
        if (object instanceof DataException) {
            DataException dataException = (DataException)object;
            String string3 = this.buildMessage(dataException.rootCause);
            if (!StringUtil.isNullOrEmpty((String)string3)) {
                object2 = string3;
            }
            return object2;
        }
        if (MethodFault.class.equals(object.getClass())) {
            String string4;
            MethodFault methodFault = (MethodFault)object;
            if (methodFault.getFaultCause() != null && !StringUtil.isNullOrEmpty((String)(string4 = this.buildMessage(methodFault.getFaultCause())))) {
                object2 = string4;
            }
        } else if (object instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)object;
            String string5 = this.buildMessage((Throwable)methodFault);
            if (!StringUtil.isNullOrEmpty((String)string5)) {
                object2 = string5;
            }
        } else if (object instanceof RuntimeFault && !StringUtil.isNullOrEmpty((String)(string = this.buildMessage((Throwable)(runtimeFault = (RuntimeFault)object))))) {
            object2 = string;
        }
        return object2;
    }

    private String buildCompositeExceptionMessage(CompositeException compositeException) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Exception exception : compositeException.getExceptions()) {
            if (exception == null) continue;
            this.buildMessage(exception, stringBuilder);
        }
        return stringBuilder.toString().trim();
    }

    private String buildMessage(Throwable throwable) {
        return this.buildMessage(throwable, new StringBuilder());
    }

    private String buildMessage(Throwable throwable, StringBuilder stringBuilder) {
        Object object;
        if (throwable == null) {
            return stringBuilder.toString();
        }
        String string = this.getLocalizedFaultMessage(throwable);
        if (!StringUtil.isNullOrEmpty((String)string)) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        if (throwable instanceof NoPermission) {
            stringBuilder.append(this.getNoPermissionFaultMessage((NoPermission)throwable));
            stringBuilder.append("\n");
        }
        LocalizableMessage[] localizableMessageArray = null;
        Exception exception = null;
        if (throwable instanceof MethodFault) {
            object = (MethodFault)throwable;
            localizableMessageArray = object.getFaultMessage();
            exception = object.getFaultCause();
        } else if (throwable instanceof RuntimeFault) {
            object = (RuntimeFault)throwable;
            localizableMessageArray = object.getFaultMessage();
            exception = object.getFaultCause();
        }
        if (exception == throwable) {
            exception = null;
        }
        if (localizableMessageArray != null) {
            object = this.locale.get();
            for (int i = localizableMessageArray.length - 1; i >= 0; --i) {
                LocalizableMessage localizableMessage;
                String string2;
                String string3 = object != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])localizableMessage.getArg(), (Locale)object) : LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])localizableMessage.getArg());
                if (string3.equals(string2 = (localizableMessage = localizableMessageArray[i]).getKey())) {
                    string3 = localizableMessage.getMessage();
                }
                String string4 = string3;
                if (StringUtil.isNullOrEmpty((String)string3)) {
                    string4 = !StringUtil.isNullOrEmpty((String)localizableMessage.getMessage()) ? localizableMessage.getMessage() : localizableMessage.getKey();
                }
                if (StringUtil.isNullOrEmpty((String)string4)) continue;
                string4 = string4.trim();
                if (!StringUtil.isNullOrEmpty((String)string) && string.equals(string4)) continue;
                stringBuilder.append(string4);
                stringBuilder.append("\n");
            }
        }
        if (exception != null && !StringUtil.isNullOrEmpty((String)(object = this.buildMessage(exception)))) {
            stringBuilder.append("\n");
            stringBuilder.append(ThrowableProxy.text("ThrowableProxy.cause"));
            stringBuilder.append("\n");
            stringBuilder.append((String)object);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().trim();
    }

    private String getLocalizedFaultMessage(Throwable throwable) {
        String string = null;
        String string2 = null;
        Locale locale = this.locale.get();
        try {
            KeyAnyValue[] keyAnyValueArray = this.constructKeyValuePairs(throwable);
            if (throwable instanceof ExtendedFault) {
                ExtendedFault extendedFault = (ExtendedFault)throwable;
                string2 = this.getMessageKey(extendedFault.getFaultTypeId());
                string = locale != null ? this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])keyAnyValueArray, (Locale)locale), extendedFault.getData()) : this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])keyAnyValueArray), extendedFault.getData());
                if (string != null && string.equals(string2)) {
                    string = null;
                }
            } else {
                string2 = this.getMessageKey(throwable.getClass().getSimpleName());
                string = locale != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])keyAnyValueArray, (Locale)locale) : LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])keyAnyValueArray);
                if (string == null || string.equals(string2)) {
                    if (this.isServiceNotAvailable(throwable)) {
                        string2 = this.getMessageKey(throwable.getClass().getSimpleName());
                        string = ThrowableProxy.text("ThrowableProxy.unexpectedStatusCode503");
                    } else {
                        string = null;
                    }
                }
            }
        }
        catch (NotAuthenticatedError notAuthenticatedError) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty(string)) {
            string = throwable.getMessage();
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private String getMessageKey(String string) {
        return String.format("%s.summary", string);
    }

    private boolean isServiceNotAvailable(Throwable throwable) {
        if (throwable instanceof UnexpectedStatusCodeException) {
            UnexpectedStatusCodeException unexpectedStatusCodeException = (UnexpectedStatusCodeException)throwable;
            return unexpectedStatusCodeException.getStatusCode() == 503;
        }
        return false;
    }

    private String getNoPermissionFaultMessage(NoPermission noPermission) {
        String string;
        String string2 = noPermission.getPrivilegeId();
        String string3 = this.getPrivilegeText(string2);
        Object object = null;
        String string4 = "?";
        ManagedObjectReference managedObjectReference = noPermission.getObject();
        if (managedObjectReference != null) {
            Boolean bl = this.canInvokeRequests.get();
            if (bl == null || bl.booleanValue()) {
                try {
                    object = QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)"name");
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to retrieve the 'name' property for " + managedObjectReference), (Throwable)exception);
                }
            }
            if (object == null || StringUtil.isNullOrEmpty((String)object.toString())) {
                object = QueryUtil.getReferenceUid((Object)managedObjectReference);
            }
            if ((string = managedObjectReference.getType()) != null) {
                string4 = ManagedObjectUtil.getLocalizedEntityType((String)string);
            } else {
                _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault's moRef contains a null type."));
            }
        } else {
            object = "?";
            _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault contains a null moRef."));
        }
        string = ThrowableProxy.text("NoPermission.message.format");
        string = String.format(string, string3, string4, object);
        return string;
    }

    private String getPrivilegeText(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return "?";
        }
        Locale locale = this.locale.get();
        String[] stringArray = string.split("\\.");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < i + 1; ++j) {
                if ((n = string.indexOf(".", n + 1)) != -1) continue;
                n = string.length();
                break;
            }
            String string2 = string.substring(0, n);
            String string3 = String.format("privilege.%s.label", string2);
            String string4 = locale != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string3, null, (Locale)locale) : LocalizationUtil.getLocalizedMessage((String)string3, null);
            if (string4 != null && !string4.equals(string3)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" > ");
                }
                stringBuffer.append(string4);
                continue;
            }
            _logger.warn((Object)("Unable to localize key '" + string3 + "'"));
        }
        return stringBuffer.toString();
    }

    private KeyAnyValue[] constructKeyValuePairs(Throwable throwable) {
        KeyAnyValue[] keyAnyValueArray = this.constructKeyValuePairs((BeanProxy)this, throwable);
        if (keyAnyValueArray == null) {
            return null;
        }
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (!(keyAnyValue.getValue() instanceof MethodFault)) continue;
            MethodFault methodFault = (MethodFault)keyAnyValue.getValue();
            keyAnyValue.setValue((Object)this.buildMessage((Throwable)methodFault));
        }
        return keyAnyValueArray;
    }

    private String fillInExtendFaultData(String string, KeyValue[] keyValueArray) {
        int n;
        String string2 = string;
        int n2 = string2.indexOf("[data.");
        if (n2 == -1 || keyValueArray == null || keyValueArray.length == 0) {
            return string2;
        }
        while ((n = string2.indexOf("]", n2 + 6)) != -1) {
            String string3 = string2.substring(n2 + 6, n);
            String string4 = null;
            for (KeyValue keyValue : keyValueArray) {
                if (!string3.equals(keyValue.getKey())) continue;
                string4 = this.escapeOpenBrace(keyValue.getValue());
                break;
            }
            if (string4 == null) {
                _logger.warn((Object)("FormatExtensionFaultData: Unable to substitute " + string3));
                string4 = String.format("<%s>", ThrowableProxy.text("ThrowableProxy.propertyUnset"));
            }
            string2 = string2.substring(0, n2) + string4 + string2.substring(n + 1);
            n2 += string4.length() + 1;
            if ((n2 = string2.indexOf("[data.", n2 + 1)) != -1) continue;
        }
        return string2;
    }

    private String escapeOpenBrace(String string) {
        int n = string.indexOf(123);
        if (n == -1) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        do {
            string2 = string2 + string.substring(n2, n + 1) + "{";
        } while ((n = string.indexOf(123, n2 = n + 1)) != -1);
        string2 = string2 + string.substring(n2);
        return string2;
    }

    private KeyAnyValue[] constructKeyValuePairs(BeanProxy beanProxy, Object object) {
        List list = beanProxy.getPropertyNames(object);
        if (list == null || list.isEmpty()) {
            return null;
        }
        list.remove(PROPERTY_NAME_MESSAGE);
        list.remove(PROPERTY_NAME_LOCALIZED_MESSAGE);
        KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[list.size()];
        int n = 0;
        for (String string : list) {
            keyAnyValueArray[n] = ThrowableProxy.newKeyValue(string, beanProxy.getValue(object, string));
            ++n;
        }
        return keyAnyValueArray;
    }

    public static KeyAnyValue newKeyValue(String string, Object object) {
        KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
        keyAnyValueImpl.setKey(string);
        keyAnyValueImpl.setValue(object);
        return keyAnyValueImpl;
    }

    private static final String text(String string) {
        ClassLoader classLoader = ThrowableProxy.class.getClassLoader();
        return ResourceUtil.getString((String)RES_BUNDLE_NAME, (String)string, (ClassLoader)classLoader);
    }
}

