/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ExtendedDescription;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.messaging.amf.BeanProxy;
import com.vmware.vise.messaging.amf.CoreAmfProxyRegistrar;
import com.vmware.vise.messaging.amf.vim.EventProxy;
import com.vmware.vise.messaging.amf.vim.ExtendedDescriptionProxy;
import com.vmware.vise.messaging.amf.vim.I18nFilterProxy;
import com.vmware.vise.messaging.amf.vim.ManagedObjectReferenceProxy;
import com.vmware.vise.messaging.amf.vim.PrivilegeProxy;
import com.vmware.vise.messaging.amf.vim.TaskInfoProxy;
import com.vmware.vise.messaging.amf.vim.ThrowableProxy;
import com.vmware.vise.messaging.amf.vim.VimExceptionProxy;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class VimAmfProxyRegistrar
extends CoreAmfProxyRegistrar {
    private static final Log _logger = LogFactory.getLog(VimAmfProxyRegistrar.class);
    private final DataService _dataService;

    protected VimAmfProxyRegistrar(@Nonnull DataService dataService) {
        Validate.notNull((Object)dataService);
        this._dataService = dataService;
    }

    public static VimAmfProxyRegistrar newInstance(@Nullable BundleContext bundleContext, @Nonnull DataService dataService) {
        VimAmfProxyRegistrar vimAmfProxyRegistrar = new VimAmfProxyRegistrar(dataService);
        vimAmfProxyRegistrar.init(bundleContext);
        return vimAmfProxyRegistrar;
    }

    protected void registerCustomProxies() {
        Class<?>[] classArray;
        SerializationContext.createThreadLocalObjects();
        for (Class<?> clazz : classArray = I18nFilterProxy.getSupportedTypes()) {
            String string = clazz.getName();
            try {
                PropertyProxyRegistry.getRegistry().register(clazz, (PropertyProxy)new I18nFilterProxy(clazz));
            }
            catch (Exception exception) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)String.format("Failed to register proxy for %s: %s", string, exception.getMessage()));
            }
        }
        PropertyProxyRegistry.getRegistry().register(ExtendedDescription.class, (PropertyProxy)new ExtendedDescriptionProxy());
        PropertyProxyRegistry.getRegistry().register(TaskInfo.class, (PropertyProxy)new TaskInfoProxy());
        PropertyProxyRegistry.getRegistry().register(Event.class, (PropertyProxy)new EventProxy());
        PropertyProxyRegistry.getRegistry().register(AuthorizationManager.Privilege.class, (PropertyProxy)new PrivilegeProxy());
        PropertyProxyRegistry.getRegistry().register(OperationResult.class, (PropertyProxy)new VimExceptionProxy());
        PropertyProxyRegistry.getRegistry().register(ResultSet.class, (PropertyProxy)new VimExceptionProxy());
        PropertyProxyRegistry.getRegistry().register(ManagedObjectReference.class, (PropertyProxy)new ManagedObjectReferenceProxy());
        BeanProxy.addIgnoreProperty(PropertyConstraint.class, (String)"propValue");
        PropertyProxyRegistry.getRegistry().register(Throwable.class, (PropertyProxy)new ThrowableProxy(this._dataService));
    }
}

