/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.adapters;

import com.google.common.base.Strings;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import java.util.ArrayList;
import java.util.List;

@Dto
public class NetworkSettingsItem {
    private static final String TYPE_OTHER = "";
    public boolean isIpv4Supported;
    public Boolean isIpv4Enabled;
    public String ipv4Address;
    public String ipv4SubnetMask;
    public String ipv4DefaultGateway;
    public Boolean isIpv6Supported;
    public Boolean isIpv6Enabled;
    public List<String> ipv6Address;
    public String ipv6DefaultGateway;
    public boolean isPreferedDnsSupported;
    public String preferedDns;
    public boolean isAlternateDnsSupported;
    public String alternateDns;
    public InternetScsiHba.IPCapabilities capabilities;
    public InternetScsiHba.IPProperties properties;

    public static NetworkSettingsItem getInstance(InternetScsiHba iHbaAdapter) {
        NetworkSettingsItem result = new NetworkSettingsItem();
        InternetScsiHba.IPCapabilities ipCapabilities = iHbaAdapter.ipCapabilities;
        InternetScsiHba.IPProperties ipProperties = iHbaAdapter.ipProperties;
        result.isIpv4Supported = ipCapabilities.addressSettable;
        result.isIpv4Enabled = ipProperties.ipv4Enabled;
        result.ipv4Address = String.format("%s %s", ipProperties.address, NetworkSettingsItem.getIpv4AddressType(ipProperties));
        result.ipv4SubnetMask = ipProperties.subnetMask;
        result.ipv4DefaultGateway = ipProperties.defaultGateway;
        result.isIpv6Supported = ipCapabilities.ipv6Supported;
        result.isIpv6Enabled = ipProperties.ipv6Enabled;
        if (ipProperties.ipv6properties != null && ipProperties.ipv6properties.iscsiIpv6Address != null) {
            result.ipv6Address = new ArrayList<String>(ipProperties.ipv6properties.iscsiIpv6Address.length);
            for (InternetScsiHba.IscsiIpv6Address address : ipProperties.ipv6properties.iscsiIpv6Address) {
                result.ipv6Address.add(String.format("%s %s", NetworkSettingsItem.ipv6AddressToString(address), NetworkSettingsItem.getIscsiHbaLocalizedIPv6AddrConfigType(address.origin)));
            }
            result.ipv6DefaultGateway = ipProperties.ipv6properties.ipv6DefaultGateway;
        }
        result.isPreferedDnsSupported = ipCapabilities.primaryDnsServerAddressSettable;
        result.preferedDns = ipProperties.primaryDnsServerAddress;
        result.isAlternateDnsSupported = ipCapabilities.alternateDnsServerAddressSettable;
        result.alternateDns = ipProperties.alternateDnsServerAddress;
        result.capabilities = ipCapabilities;
        result.properties = ipProperties;
        return result;
    }

    private static String ipv6AddressToString(InternetScsiHba.IscsiIpv6Address ipv6Address) {
        if (ipv6Address == null || ipv6Address.address == null) {
            return TYPE_OTHER;
        }
        return ipv6Address.address + "/" + ipv6Address.prefixLength;
    }

    public static String getIscsiHbaLocalizedIPv6AddrConfigType(String type2) {
        if (Strings.isNullOrEmpty((String)type2)) {
            return TYPE_OTHER;
        }
        InternetScsiHba.IscsiIpv6Address.AddressConfigurationType parsed = InternetScsiHba.IscsiIpv6Address.AddressConfigurationType.valueOf((String)type2);
        switch (parsed) {
            case DHCP: {
                return StorageStringUtil.getString("storage.adapters.properties.ipDnsConfig.ipAddrDhcpTypeFormat");
            }
            case AutoConfigured: {
                return StorageStringUtil.getString("storage.adapters.properties.ipDnsConfig.ipAddrAutoConfiguredFormat");
            }
            case Static: {
                return StorageStringUtil.getString("storage.adapters.properties.ipDnsConfig.ipAddrStaticTypeFormat");
            }
        }
        return TYPE_OTHER;
    }

    private static String getIpv4AddressType(InternetScsiHba.IPProperties ipProperties) {
        if (ipProperties.dhcpConfigurationEnabled) {
            return StorageStringUtil.getString("storage.adapters.properties.ipDnsConfig.ipAddrDhcpTypeFormat");
        }
        return StorageStringUtil.getString("storage.adapters.properties.ipDnsConfig.ipAddrStaticTypeFormat");
    }
}

