/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExtendSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.storage.util.PartitionUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;

public class VmfsDatastoreOptionItem {
    public VmfsDatastoreOption vmfsDatastoreOption;
    public String id;
    public String optionTitle;
    public String optionDetails;
    public boolean showWarningIcon;
    public int priority;
    public long maxDatastoreSize;

    public static VmfsDatastoreOptionItem newInstance(VmfsDatastoreOption vmfsDatastoreOption, DiskPartitionInfo diskPartitionInfo) {
        VmfsDatastoreOptionItem item = new VmfsDatastoreOptionItem();
        item.vmfsDatastoreOption = vmfsDatastoreOption;
        if (vmfsDatastoreOption.info instanceof VmfsDatastoreOption.SingleExtentInfo) {
            if (vmfsDatastoreOption.info.layout.partition != null && vmfsDatastoreOption.info.layout.partition.length == 1) {
                VmfsDatastoreOptionItem.populateSingleExtentSinglePartitionOptionItem(item, vmfsDatastoreOption, diskPartitionInfo);
            } else {
                VmfsDatastoreOptionItem.populateSingleExtentMultiplePartitionsOptionItem(item, vmfsDatastoreOption, diskPartitionInfo);
            }
            VmfsDatastoreOption.SingleExtentInfo singleExInfo = (VmfsDatastoreOption.SingleExtentInfo)vmfsDatastoreOption.info;
            item.id = item.optionTitle + ":" + singleExInfo.vmfsExtent.start.block + ":" + singleExInfo.vmfsExtent.end.block;
        } else if (vmfsDatastoreOption.info instanceof VmfsDatastoreOption.MultipleExtentInfo) {
            VmfsDatastoreOptionItem.populateMultiExtentOptionItem(item, vmfsDatastoreOption);
            item.id = item.optionTitle;
        }
        return item;
    }

    private static void populateSingleExtentSinglePartitionOptionItem(VmfsDatastoreOptionItem item, VmfsDatastoreOption vmfsOption, DiskPartitionInfo diskPartitionInfo) {
        if (vmfsOption.spec instanceof VmfsDatastoreExpandSpec) {
            long freeSpeceBytes = VmfsDatastoreOptionItem.getFreeSpaceSizeWhenExpanding(vmfsOption, diskPartitionInfo);
            String formattedFreeSpace = VmfsDatastoreOptionItem.formatStorage(freeSpeceBytes);
            item.optionTitle = StorageStringUtil.getString("vmfsDatastore.options.useFreeSpaceExpand", formattedFreeSpace);
            item.priority = 150;
            item.maxDatastoreSize = freeSpeceBytes;
        } else {
            item.optionTitle = StorageStringUtil.getString("vmfsDatastore.options.useAllPartitions");
            item.priority = 0;
            item.maxDatastoreSize = PartitionUtil.getMaxDatastoreSizeForVmfsOption(vmfsOption);
            if (!PartitionUtil.isDiskEmpty(diskPartitionInfo)) {
                item.showWarningIcon = true;
                item.optionDetails = PartitionUtil.isChangingPartitionFormat(vmfsOption) ? StorageStringUtil.getString("vmfsDatastore.options.warningPartitionFormat") : StorageStringUtil.getString("vmfsDatastore.options.warningFormat");
            }
        }
    }

    private static void populateSingleExtentMultiplePartitionsOptionItem(VmfsDatastoreOptionItem item, VmfsDatastoreOption vmfsOption, DiskPartitionInfo diskPartitionInfo) {
        if (vmfsOption.spec instanceof VmfsDatastoreExpandSpec) {
            long freeSpaceInBytes = VmfsDatastoreOptionItem.getFreeSpaceSizeWhenExpanding(vmfsOption, diskPartitionInfo);
            String formattedFreeSpace = VmfsDatastoreOptionItem.formatStorage(freeSpaceInBytes);
            item.optionTitle = StorageStringUtil.getString("vmfsDatastore.options.useFreeSpaceExpand", formattedFreeSpace);
            item.maxDatastoreSize = freeSpaceInBytes;
        } else {
            long freeSpaceSizeInBytes;
            item.maxDatastoreSize = freeSpaceSizeInBytes = PartitionUtil.getMaxDatastoreSizeForVmfsOption(vmfsOption);
            String formattedFreeSpaceSize = VmfsDatastoreOptionItem.formatStorage(freeSpaceSizeInBytes);
            item.optionTitle = vmfsOption.spec instanceof VmfsDatastoreExtendSpec ? StorageStringUtil.getString("vmfsDatastore.options.useFreeSpaceNewExtent", formattedFreeSpaceSize) : StorageStringUtil.getString("vmfsDatastore.options.useFreeSpace", formattedFreeSpaceSize);
        }
        item.priority = 50;
    }

    private static void populateMultiExtentOptionItem(VmfsDatastoreOptionItem optionItem, VmfsDatastoreOption vmfsOption) {
        optionItem.optionTitle = StorageStringUtil.getString("vmfsDatastore.options.useAllFreeSpace");
        optionItem.priority = 100;
        optionItem.optionDetails = StorageStringUtil.getString("vmfsDatastore.options.choseOptionDisjoint");
        optionItem.maxDatastoreSize = PartitionUtil.getMaxDatastoreSizeForVmfsOption(vmfsOption);
    }

    private static String formatStorage(long value) {
        StringBuilder formattedValue = new StringBuilder(FormatUtil.getStorageFormatted((Long)value, (long)1L, (long)-1L));
        int doubleSpaceIndex = formattedValue.indexOf("  ");
        if (doubleSpaceIndex >= 0) {
            formattedValue.delete(doubleSpaceIndex, doubleSpaceIndex + 1);
        }
        return formattedValue.toString();
    }

    private static long getFreeSpaceSizeWhenExpanding(VmfsDatastoreOption vmfsOption, DiskPartitionInfo diskPartitionInfo) {
        DiskPartitionInfo.BlockRange originalBlockRange = PartitionUtil.getExtentOriginalBlockRange(diskPartitionInfo, vmfsOption);
        long freeSpaceSizeInBytes = PartitionUtil.getMaxDatastoreSizeForVmfsOption(vmfsOption);
        if (originalBlockRange != null) {
            freeSpaceSizeInBytes -= PartitionUtil.getSizeOfBlockRange(originalBlockRange);
        }
        return freeSpaceSizeInBytes;
    }
}

