/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.multipathing;

import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;

public abstract class BaseStoragePath {
    private static final int INVALID_LUN_NUMBER = -1;
    private static final String FIXED_PATH = "VMW_PSP_FIXED";
    private static final String LEGACY_FIXED_PATH = "fixed";
    public String name;
    public String runtimeName;
    public String pathState;
    public Boolean isWorkingPath;
    public String formattedTarget;

    protected void initialize(StoragePathData pathData) {
        if (pathData.path != null) {
            this.name = pathData.path.name;
        }
        this.runtimeName = StorageUtil.formatPathRuntimeName(pathData);
        this.pathState = pathData.pathState;
        this.isWorkingPath = pathData.isWorkingPath;
        this.formattedTarget = pathData.pathTarget != null ? StorageUtil.formatTargetStringForPath(pathData.pathTarget.transport) : "";
    }

    protected static String getPreferred(BaseStoragePath path, String preferredPathName) {
        if (preferredPathName != null && preferredPathName.equals(path.runtimeName)) {
            return StorageStringUtil.getString("storage.paths.preferredString");
        }
        return "";
    }

    protected static int getLunNumber(StoragePathData pathData) {
        if (pathData.path != null && pathData.path.lunNumber != null) {
            return pathData.path.lunNumber;
        }
        return -1;
    }

    protected static String getLunId(StoragePathData pathData) {
        if (pathData.pathLun != null) {
            return pathData.pathLun.canonicalName;
        }
        return "";
    }

    public static String getPreferredPathName(MultipathInfo.LogicalUnitPolicy policy) {
        if (policy != null && policy instanceof MultipathInfo.FixedLogicalUnitPolicy) {
            MultipathInfo.FixedLogicalUnitPolicy fixedLogicalPolicy = (MultipathInfo.FixedLogicalUnitPolicy)policy;
            if (BaseStoragePath.isFixedPolicy(fixedLogicalPolicy.policy)) {
                return fixedLogicalPolicy.prefer;
            }
        }
        return null;
    }

    private static boolean isFixedPolicy(String policyKey) {
        return FIXED_PATH.equals(policyKey) || LEGACY_FIXED_PATH.equals(policyKey);
    }
}

