/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.spec.H5VmfsDatastoreUpgradeSpec;
import com.vmware.vsphere.client.h5.storage.spec.MountNfsDatastoreSpec;
import com.vmware.vsphere.client.h5.storage.spec.MountVvolDatastoreSpec;
import com.vmware.vsphere.client.h5.storage.spec.UpdateVmfsUnmapBandwidthSpec;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.storage.NfsDatastoreCreateSpec;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.vvol.CreateVvolDatastoreSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DatastoreMutationProvider.class);
    private static final String HOST_MOUNT_PROPERTY = "host";
    private static final String HOST_CONNECTION_STATE = "runtime.connectionState";
    private static final String HOST_STORAGE_SYSTEM_PROPERTY = "storageSystem";
    public static final String DATASTORE_INFO_PROPERTY = "info";
    public static final String DATASTORE_NAME_PROPERTY = "name";
    public static final String DATASTORE_SC_ID_PROPERTY = "info.vvolDS.scId";
    private static final String HOST_CONFIG_STORAGE = "Host.Config.Storage";
    private final MutationService _mutationService;
    private final QueryService _queryService;

    public DatastoreMutationProvider(MutationService mutationService, QueryServiceFactory queryServiceFactory) {
        this._mutationService = mutationService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    public ValidationResult validate(ManagedObjectReference datastoreRef, H5VmfsDatastoreUpgradeSpec spec) {
        ValidationResult dsResult = new ValidationResult();
        dsResult.entity = datastoreRef;
        if (this.getHostForVmfsDatastoreUpgrade(datastoreRef) == null) {
            String message = StorageStringUtil.getString("error.invalidHostMountForUser");
            dsResult.result = message;
        }
        return dsResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, H5VmfsDatastoreUpgradeSpec spec) {
        OperationResult dsResult = new OperationResult();
        dsResult.entity = datastoreRef;
        try {
            Datastore.HostMount hostMount = this.getHostForVmfsDatastoreUpgrade(datastoreRef);
            if (hostMount != null) {
                ManagedObjectReference hostStorageSystemMor = (ManagedObjectReference)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)hostMount.key, (String)HOST_STORAGE_SYSTEM_PROPERTY);
                StorageSystem storageSystem = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostStorageSystemMor);
                storageSystem.upgradeVmfs(hostMount.mountInfo.path);
            } else {
                dsResult.error = MixedUtil.getMethodFault((Throwable)new Exception(StorageStringUtil.getString("error.invalidHostMountForUser")));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to upgrade VMFS datastore: " + ex.getMessage()));
            dsResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return dsResult;
    }

    private Datastore.HostMount getHostForVmfsDatastoreUpgrade(ManagedObjectReference datastoreRef) {
        Datastore.HostMount[] hostMounts = (Datastore.HostMount[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)datastoreRef, (String)HOST_MOUNT_PROPERTY);
        if (hostMounts == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> mountedAndAccessibleHosts = new ArrayList<ManagedObjectReference>();
        for (Datastore.HostMount hostMount : hostMounts) {
            if (!Boolean.TRUE.equals(hostMount.mountInfo.mounted) || !Boolean.TRUE.equals(hostMount.mountInfo.accessible)) continue;
            mountedAndAccessibleHosts.add(hostMount.key);
        }
        if (mountedAndAccessibleHosts.isEmpty()) {
            return null;
        }
        Map hostData = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, mountedAndAccessibleHosts, (String[])new String[]{HOST_CONNECTION_STATE, "grantedPrivileges"});
        for (Datastore.HostMount hostMount : hostMounts) {
            Map hostProperties = (Map)hostData.get(hostMount.key);
            if (hostProperties == null || HostSystem.ConnectionState.connected != hostProperties.get(HOST_CONNECTION_STATE) || !AuthorizationUtil.isPrivilegeGranted((String[])new String[]{HOST_CONFIG_STORAGE}, (String[])((String[])hostProperties.get("grantedPrivileges")))) continue;
            return hostMount;
        }
        return null;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, MountNfsDatastoreSpec spec) {
        OperationResult opResult = DatastoreMutationProvider.validateMountDatastoreOperationSpecs(datastoreRef, spec);
        opResult.entity = datastoreRef;
        if (opResult.error != null) {
            return opResult;
        }
        Map dsPropertyResult = (Map)QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, Arrays.asList(datastoreRef), (String[])new String[]{DATASTORE_INFO_PROPERTY, HOST_MOUNT_PROPERTY}).get(datastoreRef);
        if (dsPropertyResult == null || dsPropertyResult.get(DATASTORE_INFO_PROPERTY) == null) {
            _logger.error((Object)String.format("Can not retrieve datastore info for datastore %s", datastoreRef));
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (!(dsPropertyResult.get(DATASTORE_INFO_PROPERTY) instanceof NasDatastoreInfo)) {
            _logger.error((Object)String.format("Can not mount datastore %s as NFS. The datastore is not NFS.", datastoreRef));
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        NasDatastoreInfo datastoreInfo = (NasDatastoreInfo)dsPropertyResult.get(DATASTORE_INFO_PROPERTY);
        NasVolume nasVolume = datastoreInfo.nas;
        OperationEffect opEffect = OperationEffect.newDelayedEffect();
        opEffect.affectedEntites = new Object[spec.hostsToMount.length + 1];
        opResult.effect = opEffect;
        Datastore.HostMount[] hostMounts = (Datastore.HostMount[])dsPropertyResult.get(HOST_MOUNT_PROPERTY);
        String accessMode = MountInfo.AccessMode.readWrite.name();
        if (hostMounts != null && hostMounts.length > 0) {
            accessMode = hostMounts[0].mountInfo.accessMode;
        }
        Object[] datastoreCreateSpecs = new NfsDatastoreCreateSpec[spec.hostsToMount.length];
        for (int i = 0; i < spec.hostsToMount.length; ++i) {
            opEffect.affectedEntites[i] = spec.hostsToMount[i];
            datastoreCreateSpecs[i] = DatastoreMutationProvider.buildNfsDatastoreCreateSpec(spec.hostsToMount[i], datastoreInfo, nasVolume, accessMode);
        }
        this._mutationService.addMulti(datastoreCreateSpecs);
        opEffect.affectedEntites[spec.hostsToMount.length] = datastoreRef;
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, MountVvolDatastoreSpec spec) {
        OperationResult opResult = DatastoreMutationProvider.validateMountDatastoreOperationSpecs(datastoreRef, spec);
        opResult.entity = datastoreRef;
        if (opResult.error != null) {
            return opResult;
        }
        Map dsPropertyResult = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)datastoreRef, (String[])new String[]{DATASTORE_SC_ID_PROPERTY, DATASTORE_NAME_PROPERTY});
        if (dsPropertyResult == null || dsPropertyResult.get(DATASTORE_SC_ID_PROPERTY) == null) {
            _logger.error((Object)String.format("Can not retrieve datastore scId for datastore %s", datastoreRef));
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (dsPropertyResult.get(DATASTORE_NAME_PROPERTY) == null) {
            _logger.error((Object)String.format("Can not retrieve datastore name for datastote %s", datastoreRef));
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        String datastoreName = (String)dsPropertyResult.get(DATASTORE_NAME_PROPERTY);
        String datastoreScId = (String)dsPropertyResult.get(DATASTORE_SC_ID_PROPERTY);
        OperationEffect opEffect = OperationEffect.newDelayedEffect();
        opEffect.affectedEntites = new Object[spec.hostsToMount.length + 1];
        opResult.effect = opEffect;
        Object[] datastoreCreateSpecs = new CreateVvolDatastoreSpec[spec.hostsToMount.length];
        for (int i = 0; i < spec.hostsToMount.length; ++i) {
            opEffect.affectedEntites[i] = spec.hostsToMount[i];
            datastoreCreateSpecs[i] = DatastoreMutationProvider.buildVVolDatastoreCreateSpec(spec.hostsToMount[i], datastoreName, datastoreScId);
        }
        this._mutationService.addMulti(datastoreCreateSpecs);
        opEffect.affectedEntites[spec.hostsToMount.length] = datastoreRef;
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, UpdateVmfsUnmapBandwidthSpec spec) {
        OperationResult opResult = DatastoreMutationProvider.validateUpdateVmfsUnmapBandwidthSpec(spec);
        opResult.entity = spec.datastore;
        if (opResult.error != null) {
            return opResult;
        }
        OperationEffect opEffect = OperationEffect.newDelayedEffect();
        opEffect.affectedEntites = new Object[]{spec.datastore};
        opResult.effect = opEffect;
        try {
            ManagedObjectReference hostStorageSystemMor = (ManagedObjectReference)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)hostRef, (String)HOST_STORAGE_SYSTEM_PROPERTY);
            StorageSystem storageSystem = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostStorageSystemMor);
            storageSystem.updateVmfsUnmapBandwidth(spec.vmfsUuid, spec.unmapBandwidthSpec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to update vmfs bandwidth spec.", (Throwable)ex);
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    private static CreateVvolDatastoreSpec buildVVolDatastoreCreateSpec(ManagedObjectReference hostRef, String datastoreName, String datastoreScId) {
        DatastoreSystem.VvolDatastoreSpec vvolDsSpec = new DatastoreSystem.VvolDatastoreSpec();
        vvolDsSpec.scId = datastoreScId;
        vvolDsSpec.name = datastoreName;
        CreateVvolDatastoreSpec datastoreCreateSpecs = new CreateVvolDatastoreSpec();
        datastoreCreateSpecs.host = hostRef;
        datastoreCreateSpecs.vvolDatastoreSpec = vvolDsSpec;
        return datastoreCreateSpecs;
    }

    private static NfsDatastoreCreateSpec buildNfsDatastoreCreateSpec(ManagedObjectReference hostRef, NasDatastoreInfo datastoreInfo, NasVolume nasVolume, String accessMode) {
        NfsDatastoreCreateSpec datastoreCreateSpecs = new NfsDatastoreCreateSpec();
        datastoreCreateSpecs.host = hostRef;
        datastoreCreateSpecs.nfsDatastoreCreateSpec = new NasVolume.Specification();
        datastoreCreateSpecs.nfsDatastoreCreateSpec.localPath = datastoreInfo.name;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.remoteHost = nasVolume.remoteHost;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.remoteHostNames = nasVolume.remoteHostNames;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.remotePath = nasVolume.remotePath;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.accessMode = accessMode;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.type = nasVolume.type;
        datastoreCreateSpecs.nfsDatastoreCreateSpec.securityType = nasVolume.securityType;
        return datastoreCreateSpecs;
    }

    private static OperationResult validateUpdateVmfsUnmapBandwidthSpec(UpdateVmfsUnmapBandwidthSpec spec) {
        OperationResult opResult = new OperationResult();
        if (spec.datastore == null) {
            _logger.error((Object)"Invalid UpdateVmfsUnmapBandwidthSpec - datastore is null.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (spec.vmfsUuid == null) {
            _logger.error((Object)"Invalid UpdateVmfsUnmapBandwidthSpec - vmfsUuid is null.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (spec.unmapBandwidthSpec == null) {
            _logger.error((Object)"Invalid UpdateVmfsUnmapBandwidthSpec - unmapBandwidthSpec is null.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        return opResult;
    }

    private static OperationResult validateMountDatastoreOperationSpecs(ManagedObjectReference datastoreRef, Object spec) {
        OperationResult opResult = new OperationResult();
        ManagedObjectReference[] hostsToMount = null;
        if (spec instanceof MountVvolDatastoreSpec) {
            MountVvolDatastoreSpec vvolSpec = (MountVvolDatastoreSpec)spec;
            hostsToMount = vvolSpec.hostsToMount;
        } else if (spec instanceof MountNfsDatastoreSpec) {
            MountNfsDatastoreSpec nfsSpec = (MountNfsDatastoreSpec)spec;
            hostsToMount = nfsSpec.hostsToMount;
        } else {
            _logger.error((Object)("DatastoreSpec can not be instance of " + spec.getClass().getSimpleName()));
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (datastoreRef == null) {
            _logger.error((Object)"datastoreRef can not be null when mounting datastore.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (spec == null) {
            _logger.error((Object)"DatastoreSpec can not be null.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (hostsToMount == null) {
            _logger.error((Object)"hostsToMount can not be null.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        if (hostsToMount.length == 0) {
            _logger.error((Object)"hostsToMount can not be empty.");
            opResult.error = StorageUtil.getFault((String)"error.invalidArgument");
            return opResult;
        }
        return opResult;
    }
}

